/************************************\
*         Sweet Sixteen              *
*                                    *
*     Bert Schnwlder, 1996         *
*                                    *
* Sixteen cute things to play with   *
* while thinking ...                 *
*                                    *
* - feel free to modify -            *
*                                    *
* eMail: bert@cs.uni-magdeburg.de    *
\************************************/

#include <owl\owlpch.h>
#pragma hdrstop
#include <owl\floatfra.h>
#include <owl\toolbox.h>
#include <owl\buttonga.h>

#include "sixteen.rc"

/////////////////////////////////////////////////////////////////////////////

class TButtonPalette : public TFloatingFrame {
	typedef TFloatingFrame inherited;
	public:
		TButtonPalette(TWindow* parent, char* title=0, TWindow* client= 0)
			: TFloatingFrame(parent, title, client, TRUE)
			{
				Attr.Style = WS_POPUP | WS_BORDER | WS_VISIBLE;
				EnableTinyCaption(60, TRUE);
			}
	private:
		void SetupWindow();
		void CleanupWindow();
		void EvCommandEnable( TCommandEnabler &ce) {Parent->EvCommandEnable(ce);}
		void EvClose() {CloseWindow();}
		UINT EvMouseActivate(HWND, UINT hittest, UINT msg) {return MA_NOACTIVATE;}
		BOOL IdleAction(long l)
			{if (GetActiveWindow()==*this) Parent->SetActiveWindow();
			 return inherited::IdleAction(l);}

	DECLARE_RESPONSE_TABLE(TButtonPalette);
};

DEFINE_RESPONSE_TABLE1(TButtonPalette, TFloatingFrame)
	EV_WM_CLOSE,
	EV_WM_MOUSEACTIVATE,
END_RESPONSE_TABLE;

void TButtonPalette::SetupWindow()
{
	TFloatingFrame::SetupWindow();
	if (Attr.X < 0 || Attr.Y < 0) {
		TRect r = Parent->GetClientRect();
		Parent->ClientToScreen(r.TopLeft());
		r.Offset(-GetSystemMetrics(SM_CXFRAME)-Attr.W, -CaptionHeight-1);
		SetWindowPos(0, r, SWP_NOSIZE | SWP_NOZORDER);
	}
}

void TButtonPalette::CleanupWindow()
{
	TRect rect;
	GetWindowRect(rect);
	Attr.X = rect.left;
	Attr.Y = rect.top;
	TFloatingFrame::CleanupWindow();
}

/////////////////////////////////////////////////////////////////////////////

class TMyButtonGadget : public TButtonGadget {
	typedef TButtonGadget inherited;
	public:
		TMyButtonGadget(TResId bmpResId, int id, TType type=Command,
			BOOL enabled = TRUE, TState state = Up, BOOL repeat = FALSE)
			: TButtonGadget(bmpResId, id, type, enabled, state, repeat) {}
	protected:
		void LButtonDown(UINT modKeys, TPoint& p);
		void LButtonUp(UINT modKeys, TPoint& p);
};

void TMyButtonGadget::LButtonDown(UINT modKeys, TPoint& p)
{
	inherited::LButtonDown(modKeys, p);
	if (Type==Command) {
		Window->Parent->SendMessage(WM_COMMAND, GetId());
		LButtonUp(modKeys, p);
	}
}

void TMyButtonGadget::LButtonUp(UINT modKeys, TPoint& p)
{
	if (Type==Command) {
		TGadget::LButtonUp(modKeys, p);
		if (Pressed) CancelPressed(p);
	}
	else inherited::LButtonUp(modKeys, p);
}


/////////////////////////////////////////////////////////////////////////////


//----------------------------------------------------------------------------

#define CM_REP 	200
#define CM_ATTR 300
#define CM_LOAD 400
#define CM_SAVE 500

const Count = 16;
const RepStrength[10] = {0,10,20,40,70,100,150,200,230,250};
const AttrDist[10] = {0,80,60,50,40,30,20,15,10,5};
const MsgTime = 50;

class TTestWindow : public TFrameWindow {
  typedef TFrameWindow inherited;
	TPoint Pos[Count];
	TSize Dir[Count];
	TRect Rec[Count];
	TPoint Ico[Count];
	unsigned ConnMat[Count];
	unsigned IcoMat[Count];
	int Current, Other;
	BOOL Dragging, PreDrag;
	TPoint Last, CurPos;
	BOOL MouseConnect;

	BOOL Random;
	BOOL RandConn;
	BOOL Attraction;
	BOOL Repulsion;
	int DistA, DistR;
	int CurAttr, CurRep;

	int MsgWait;
	char *Msg;

	TButtonPalette* ToolWin;
	TToolBox* ToolBox;
	BOOL Horiz;
	int Balls;

	public:
		TTestWindow();
		~TTestWindow();

		BOOL Connected( int a, int b, BOOL useIco=FALSE);
		void Connect( int a, int b, BOOL useIco=FALSE);
		void ClearConns();
		void MakeCycl();
		void MakeLine();
		void MakeGrid();
		void Scramble();
		void Direction();
		void Relax();
		void AttrMenu();
		void RepMenu();
		void LSMenu();
		void ButtonDown( TPoint&, BOOL);
		void ButtonUp( TPoint&);

		void SavePara(char *name = "Save");
		void LoadPara(char *name = "Save");
		BOOL LoadIcon(char *name);

	protected:
		void SetupWindow();
		void CleanupWindow() {::ClipCursor(0);}
		void Paint( TDC&, BOOL, TRect&);
		void CalcIcon();
		void PaintIcon( TDC& dc);
		BOOL IdleAction(long l) {
			if (IsIconic()) return FALSE;
			inherited::IdleAction(l);
			if (Dragging||PreDrag) EvMouseMove(0, CurPos); else Relax();
			return TRUE;}

		void EvChar( UINT, UINT, UINT) {if (!Dragging) Scramble();
			else {int r=rand()%50; Dir[Current]=TSize(r, 50-r);}}
		void EvKeyDown( UINT key, UINT, UINT) {if (key==VK_F1)
			{Msg=ToolWin->HWindow ? ":-)" : "double-click for tools"; MsgWait=MsgTime;}
			else DefaultProcessing();}
		void EvMove(TPoint&);
		void EvLButtonDown( UINT, TPoint&p) {ButtonDown(p, FALSE);}
		void EvRButtonDown( UINT, TPoint&p) {ButtonDown(p, TRUE);}
		void EvLButtonUp( UINT, TPoint&p) {ButtonUp(p);}
		void EvRButtonUp( UINT, TPoint&p) {ButtonUp(p);}
		void EvMouseMove( UINT, TPoint&);
		void EvLButtonDblClk( UINT, TPoint&)
			{if (ToolWin->HWindow) ToolWin->Destroy(); else ToolWin->Create();}
		void EvNCRButtonDown( UINT, TPoint& p)
			{if (ToolWin->HWindow) ToolWin->Destroy(); else ToolWin->Create();}
		void EvTimer( UINT) {Relax();}
		void EvRepStrength(WPARAM p)
			{DistR = RepStrength[CurRep=p-CM_REP]; Repulsion=TRUE;}
		void EvAttrDist(WPARAM p)
			{DistA = AttrDist[CurAttr=p-CM_ATTR]; Attraction=TRUE;}
		void EvSave(WPARAM p) {char *s="Save0"; s[4]='0'+p-CM_SAVE; SavePara(s);}
		void EvLoad(WPARAM p) {char *s="Save0"; s[4]='0'+p-CM_LOAD; LoadPara(s);}

		void EvRandom() {Random = !Random;}
		void EnRandom(TCommandEnabler &en) {en.SetCheck(Random);}
		void EvAttraction() {Attraction = !Attraction;}
		void EnAttraction(TCommandEnabler &en) {en.SetCheck(Attraction);}
		void EvRepulsion() {Repulsion = !Repulsion;}
		void EnRepulsion(TCommandEnabler &en) {en.SetCheck(Repulsion);}
		void EvRandConn() {RandConn = !RandConn;}
		void EnRandConn(TCommandEnabler &en) {en.SetCheck(RandConn);}

		void ChangeBalls() {Balls = (Balls+1)%3;}
	DECLARE_RESPONSE_TABLE(TTestWindow);
};


DEFINE_RESPONSE_TABLE1(TTestWindow, inherited)
	EV_WM_LBUTTONDOWN,
	EV_WM_LBUTTONUP,
	EV_WM_RBUTTONDOWN,
	EV_WM_RBUTTONUP,
	EV_WM_MOUSEMOVE,
	EV_WM_NCRBUTTONDOWN,
	EV_WM_LBUTTONDBLCLK,
	EV_WM_TIMER,
	EV_WM_CHAR,
	EV_WM_KEYDOWN,
	EV_WM_MOVE,
	EV_COMMAND( CM_DIRECTION, Direction),
	EV_COMMAND( CM_SCRAMBLE, Scramble),
	EV_COMMAND( CM_CLEARCONN, ClearConns),
	EV_COMMAND( CM_MAKECYCL, MakeCycl),
	EV_COMMAND( CM_MAKEGRID, MakeGrid),
	EV_COMMAND( CM_MAKELINE, MakeLine),
	EV_COMMAND( CM_BALLS, ChangeBalls),
	EV_COMMAND( CM_ATTRMENU, AttrMenu),
	EV_COMMAND( CM_REPMENU, RepMenu),
	EV_COMMAND( CM_LSMENU, LSMenu),

	EV_COMMAND( CM_RANDOM, EvRandom),
	EV_COMMAND_ENABLE( CM_RANDOM, EnRandom),
	EV_COMMAND( CM_ATTRACTION, EvAttraction),
	EV_COMMAND_ENABLE( CM_ATTRACTION, EnAttraction),
	EV_COMMAND( CM_REPULSION, EvRepulsion),
	EV_COMMAND_ENABLE( CM_REPULSION, EnRepulsion),
	EV_COMMAND( CM_RANDCONN, EvRandConn),
	EV_COMMAND_ENABLE( CM_RANDCONN, EnRandConn),

	EV_COMMAND_AND_ID( CM_REP+1, EvRepStrength),
	EV_COMMAND_AND_ID( CM_REP+2, EvRepStrength),
	EV_COMMAND_AND_ID( CM_REP+3, EvRepStrength),
	EV_COMMAND_AND_ID( CM_REP+4, EvRepStrength),
	EV_COMMAND_AND_ID( CM_REP+5, EvRepStrength),
	EV_COMMAND_AND_ID( CM_REP+6, EvRepStrength),
	EV_COMMAND_AND_ID( CM_REP+7, EvRepStrength),
	EV_COMMAND_AND_ID( CM_REP+8, EvRepStrength),
	EV_COMMAND_AND_ID( CM_REP+9, EvRepStrength),

	EV_COMMAND_AND_ID( CM_ATTR+1, EvAttrDist),
	EV_COMMAND_AND_ID( CM_ATTR+2, EvAttrDist),
	EV_COMMAND_AND_ID( CM_ATTR+3, EvAttrDist),
	EV_COMMAND_AND_ID( CM_ATTR+4, EvAttrDist),
	EV_COMMAND_AND_ID( CM_ATTR+5, EvAttrDist),
	EV_COMMAND_AND_ID( CM_ATTR+6, EvAttrDist),
	EV_COMMAND_AND_ID( CM_ATTR+7, EvAttrDist),
	EV_COMMAND_AND_ID( CM_ATTR+8, EvAttrDist),
	EV_COMMAND_AND_ID( CM_ATTR+9, EvAttrDist),

	EV_COMMAND_AND_ID( CM_LOAD+1, EvLoad),
	EV_COMMAND_AND_ID( CM_LOAD+2, EvLoad),
	EV_COMMAND_AND_ID( CM_LOAD+3, EvLoad),
	EV_COMMAND_AND_ID( CM_LOAD+4, EvLoad),
	EV_COMMAND_AND_ID( CM_LOAD+5, EvLoad),

	EV_COMMAND_AND_ID( CM_SAVE+1, EvSave),
	EV_COMMAND_AND_ID( CM_SAVE+2, EvSave),
	EV_COMMAND_AND_ID( CM_SAVE+3, EvSave),
	EV_COMMAND_AND_ID( CM_SAVE+4, EvSave),
	EV_COMMAND_AND_ID( CM_SAVE+5, EvSave),
END_RESPONSE_TABLE;

#define FORALLCONN(a,b)\
	for (b=1; b<Count; b++)\
		for (a=0; a<b; a++)\
			if (Connected(a,b))

TSize operator*(const TSize &s, int a) {return TSize(s.cx*a, s.cy*a);}
TSize operator/(const TSize &s, int a) {return TSize(s.cx/a, s.cy/a);}
TSize& operator/=(TSize &s, int a) {s.cx/=a; s.cy/=a; return s;}
TSize& operator*=(TSize &s, int a) {s.cx*=a; s.cy*=a; return s;}


#define COMM TButtonGadget::Command
#define EXCL TButtonGadget::NonExclusive
TTestWindow::TTestWindow() : TFrameWindow(0, "Sweet Sixteen", 0)
{
	TToolBox* tb = ToolBox = new TToolBox(0, 1);
	tb->Insert(*new TButtonGadget(CM_DIRECTION, CM_DIRECTION, COMM, TRUE));
	tb->Insert(*new TButtonGadget(CM_CLEARCONN, CM_CLEARCONN, COMM, TRUE));
	tb->Insert(*new TButtonGadget(CM_MAKECYCL, CM_MAKECYCL, COMM, TRUE));
	tb->Insert(*new TButtonGadget(CM_MAKELINE, CM_MAKELINE, COMM, TRUE));
	tb->Insert(*new TButtonGadget(CM_MAKEGRID, CM_MAKEGRID, COMM, TRUE));
	tb->Insert(*new TButtonGadget(CM_SCRAMBLE, CM_SCRAMBLE, COMM, TRUE));
	tb->Insert(*new TButtonGadget(CM_RANDCONN, CM_RANDCONN, EXCL, TRUE));
	tb->Insert(*new TButtonGadget(CM_RANDOM, CM_RANDOM, EXCL, TRUE));
	tb->Insert(*new TButtonGadget(CM_ATTRACTION, CM_ATTRACTION, EXCL, TRUE));
	tb->Insert(*new TButtonGadget(CM_REPULSION, CM_REPULSION, EXCL, TRUE));
	tb->Insert(*new TMyButtonGadget(CM_ATTRMENU, CM_ATTRMENU, COMM, TRUE));
	tb->Insert(*new TMyButtonGadget(CM_REPMENU, CM_REPMENU, COMM, TRUE));
	tb->Insert(*new TButtonGadget(CM_BALLS, CM_BALLS, COMM, TRUE));
	tb->Insert(*new TMyButtonGadget(CM_LSMENU, CM_LSMENU, COMM, TRUE));
	ToolWin = new TButtonPalette(this, "16", tb);

	Dragging = PreDrag = FALSE;
	Current = Other = 0;
	SetBkgndColor( NoErase);
	MakeGrid();
	Random = Attraction = Repulsion = TRUE;
	MouseConnect = RandConn = FALSE;
	DistA = AttrDist[CurAttr=6];
	DistR = RepStrength[CurRep=7];
	Balls = GetPrivateProfileInt("Options", "Balls", 0, "sixteen.ini")%3;
	Msg = " 1996 Bert Schnwlder";
	MsgWait = 2*MsgTime;
	Scramble();
	LoadPara();
}

TTestWindow::~TTestWindow()
{
	SavePara();
	char n[]="0";
	*n = '0'+Balls;
	WritePrivateProfileString("Options", "Balls", n, "sixteen.ini");
}

void TTestWindow::SetupWindow()
{
	inherited::SetupWindow();
//	TSystemMenu m(*this);
//	m.AppendMenu(MF_SEPARATOR);
//	m.AppendMenu(0, 0, "Test");
}

void TTestWindow::Direction()
{
	TRect r;
	if (ToolWin->HWindow) {
		ToolWin->GetWindowRect(r);
		ToolWin->ShowWindow(SW_HIDE);
	}
	Horiz= !Horiz;
	ToolBox->SetDirection((TToolBox::TTileDirection)(Horiz ? 1 : 0));
	ToolWin->SetCaption(Horiz ? "Sweet Sixteen" : "16" );
	if (ToolWin->HWindow) {
		ToolWin->SetWindowPos(0, r, SWP_NOSIZE | SWP_NOZORDER);
		ToolWin->ShowWindow(SW_SHOW);
	}
}

void TTestWindow::EvMove(TPoint&)
{
	TRect r;
	if (ToolWin->HWindow)
		ToolWin->GetWindowRect(r);
	TPoint p(Attr.X, Attr.Y);
	inherited::EvMove(p);
	if (ToolWin->HWindow)
		ToolWin->MoveWindow(r.OffsetBy(Attr.X-p.x, Attr.Y-p.y), TRUE);
}


#define PUT(c) *dest++=c
#define PUTA(c) PUT('A'+(c))
#define PUT0(c) PUT('0'+(c))
#define PUTH(c) PUTA((c)&0x3f)
#define PUTN(n) {PUTH(n>>12); PUTH(n>>6); PUTH(n);}
#define	PUTLINE(line) PUT(0);dest=buf;\
	WritePrivateProfileString(name,line,buf,"sixteen.ini")

void TTestWindow::SavePara( char *name)
{
	int a;
	char buf[130];
	char *dest=buf;
	for (a=0; a<Count; a++) PUTN(ConnMat[a])
	PUTLINE("Conn");
	for (a=0; a<Count; a++) PUTN(Pos[a].x)
	PUTLINE("PosX");
	for (a=0; a<Count; a++) PUTN(Pos[a].y)
	PUTLINE("PosY");
	CalcIcon();
	PUT0(Random);
	PUT0(CurAttr);
	PUT0(CurRep);
	PUT0(Attraction);
	PUT0(Repulsion);
	for (a=0; a<Count; a++) {PUTA(Ico[a].x); PUTA(Ico[a].y);};
	PUTLINE("Para");
}


#define GETLINE(line)	(GetPrivateProfileString\
	(name,line,"@",source=buf,sizeof(buf),"sixteen.ini") && *buf!='@')
#define GET (*source++)
#define GETA (GET-'A')
#define GET0 (GET-'0')
#define GETH (GETA&0x3f)
#define GETN(a) {a=(int)(GETH<<12);a|=(GETH<<6); a|=GETH;}

BOOL TTestWindow::LoadIcon( char *name)
{
	char buf[130];
	char *source;
	if (!GETLINE("Para")) return FALSE;
	source += 5;
	int a;
	for (a=0; a<Count; a++) {Ico[a].x = GETA; Ico[a].y = GETA;}
	if (GETLINE("Conn"))
		for (a=0; a<Count; a++) GETN(IcoMat[a])
	else
		for (a=0; a<Count; a++) IcoMat[a] = 0;
	return TRUE;
}

void TTestWindow::LoadPara( char *name)
{
	char buf[130];
	char *source;
	if (!LoadIcon(name)) return;
	int a;
	if (GETLINE("Para")) {
		Random = GET0 ? TRUE : FALSE;
		DistA = AttrDist[CurAttr=GET0];
		DistR = RepStrength[CurRep=GET0];
		Attraction = GET0 ? TRUE : FALSE;
		Repulsion = GET0 ? TRUE : FALSE;
	}
	if (!Repulsion) {
		if (GETLINE("PosX"))
			for (a=0; a<Count; a++) GETN(Pos[a].x)
		if (GETLINE("PosY"))
			for (a=0; a<Count; a++) GETN(Pos[a].x)
	}
	if (GETLINE("Conn"))
		for (a=0; a<Count; a++) {
			ConnMat[a] = IcoMat[a];
			Dir[a]=TSize(0,0);
		}
}

void TTestWindow::ClearConns()
{
	memset( &ConnMat, 0, sizeof ConnMat);
}

void TTestWindow::MakeCycl()
{
	ClearConns();
	Connect(0, Count-1);
	for (int a=1; a<Count; a++) Connect(a-1, a);
}

void TTestWindow::MakeLine()
{
	ClearConns();
	for (int a=1; a<Count; a++) Connect(a-1, a);
}

void TTestWindow::MakeGrid()
{
	ClearConns();
	for (int j=0; j<4; j++)
		for (int i=0; i<3; i++) {
			Connect(4*j+i, 4*j+i+1);
			Connect(4*i+j, 4*i+j+4);
		}
}

void TTestWindow::Connect( int a, int b, BOOL useIco)
{
	if (a!=b)
		if (useIco) {IcoMat[a] ^= 1<<b; IcoMat[b] ^= 1<<a;}
		else {ConnMat[a] ^= 1<<b; ConnMat[b] ^= 1<<a;}
}

BOOL TTestWindow::Connected( int a, int b, BOOL useIco)
{
	if (useIco) return ((IcoMat[a] & (1<<b))!=0);
	else return ((ConnMat[a] & (1<<b))!=0);
}

inline void inv(int &i) {i = -i;}

void TTestWindow::Paint( TDC& winDC, BOOL, TRect&)
{
	if (IsIconic()) {CalcIcon(); PaintIcon(winDC); return;}
	int i, j;
	BOOL mc = Dragging && MouseConnect;
	TRect cr = GetClientRect();
	int m = Balls!=2 ? 20+min(cr.Width(), cr.Height())/30 : 32;
	TSize ElemSize = TSize(m,m);
	//Limit Rects
	for (i=0; i<Count; i++) {
		TSize offs(ElemSize/2);
		TRect re = cr.InflatedBy(-offs);
		if (Pos[i].x<re.left) {Pos[i].x=re.left; inv(Dir[i].cx);}
		if (Pos[i].x>re.right) {Pos[i].x=re.right; inv(Dir[i].cx);}
		if (Pos[i].y<re.top) {Pos[i].y=re.top; inv(Dir[i].cy);}
		if (Pos[i].y>re.bottom) {Pos[i].y=re.bottom; inv(Dir[i].cy);}
		Rec[i] = TRect( Pos[i]-offs, ElemSize);
	}
	//Show rubberline for faster feedback
	static TPoint PrevA;
	static TPoint PrevB;
	if (mc && Current==Other) {
		winDC.SelectObject(TPen(TColor::LtGray));
		winDC.MoveTo(PrevA);
		winDC.LineTo(PrevB);
		winDC.SelectObject(TPen(TColor::LtRed));
		winDC.MoveTo(PrevA=Pos[Current]);
		winDC.LineTo(PrevB=Last);
	}
	//Clear Memory
	TMemoryDC dc;
	TBitmap bits( winDC, cr.Width(), cr.Height());
	dc.SelectObject( bits);
	dc.TextRect( cr, TColor::LtGray);
	//Show message
	if (MsgWait) {
		dc.SelectObject(TFont( "Arial", -28, 0, 0, 0, FW_NORMAL,
			VARIABLE_PITCH | FF_SWISS, FALSE, FALSE, FALSE, ANSI_CHARSET,
			OUT_CHARACTER_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY));
		dc.SetTextAlign( TA_BASELINE | TA_CENTER);
		dc.SetTextColor( TColor::Gray);
		dc.SetBkMode(TRANSPARENT);
		dc.TextOut( cr.Size()/2, Msg);
		MsgWait--;
	}
	//Show Connections
	dc.SelectObject(TPen(Attraction ? TColor::Black : TColor::Gray));
	FORALLCONN( i, j)
		if (!mc || i!=Current && i!=Other || j!=Current && j!=Other) {
			dc.MoveTo(Pos[i]);
			dc.LineTo(Pos[j]);
		}
	if (mc && Current!=Other && !Connected(Current,Other)){
		dc.MoveTo(Pos[Current]);
		dc.LineTo(Pos[Other]);
	}
	if (!Attraction) dc.SelectStockObject(BLACK_PEN);
	//Show Rects
	switch (Balls) {
		case 0:
			dc.SelectStockObject(NULL_BRUSH);
			for (i=0; i<Count; i++) {
				TRect r(Rec[i]);
				dc.Rectangle( r);
				r.Inflate( -1, -1);
				dc.SetBkColor((Dragging && (i==Current || i==Other) ?
					TColor::LtRed : TColor::LtYellow));
				dc.TextRect(r);
			}
			break;
		case 1: {
			TBrush RedBrush(TColor::LtRed);
			TBrush YellowBrush(TColor::LtYellow);
			for (i=0; i<Count; i++) {
				dc.SelectObject(Dragging && (i==Current || i==Other) ?
					RedBrush : YellowBrush);
				dc.Ellipse(Rec[i]);
			}
			break; }
		case 2:
			static TIcon RedBall(*::Module, IDI_REDBALL);
			static TIcon YellowBall(*::Module, IDI_YELLOWBALL);
			for (i=0; i<Count; i++)
				dc.DrawIcon(Rec[i].TopLeft(), Dragging && (i==Current || i==Other) ?
					RedBall : YellowBall);
			break;
	}
	//Show rubberline
	if (mc && Current==Other) {
		dc.SelectObject(TPen(TColor::LtRed));
		dc.MoveTo(PrevA);
		dc.LineTo(PrevB);
	}
	//To screen
	winDC.BitBlt( cr, dc, TPoint(0, 0));
}

void TTestWindow::CalcIcon()
{
	TRect r(0,0,0,0);
	for (int i=1; i<Count; i++) r |= TRect(Pos[0], Pos[i]).Normalized();
	int f = max(max(r.Width(), r.Height()),2);
	TSize offs((32-(r.Width()*26)/f )/2-1,(32-(r.Height()*26)/f)/2-1);
	for (i=0; i<Count; i++) {
		Ico[i] = offs+((Pos[i]-r.TopLeft())*26)/f;
		IcoMat[i] = ConnMat[i];
	}
}

void TTestWindow::PaintIcon(TDC &dc)
{
	dc.SelectStockObject(BLACK_PEN);
	dc.SelectObject(TBrush(TColor::LtYellow));
	TSize s(2,2);
	int a, b;
	for (b=1; b<Count; b++)
		for (a=0; a<b; a++)
			if (Connected(a,b, TRUE)) {
				dc.MoveTo( Ico[a]+s);
				dc.LineTo(Ico[b]+s);
			}
	s*=2;
	for (a=0; a<Count; a++) dc.Rectangle(Ico[a], s);
}

void TTestWindow::Scramble()
{
	for (int i=0; i<Count; i++)
		Dir[i]= TSize(rand()%100-50, rand()%100-50);
	Relax();
}

TSize scale( TSize &s, long m, long d=1)
{
	return TSize((int)((s.cx*m)/d), (int)((s.cy*m)/d));
}

void TTestWindow::Relax()
{
	int a, b, i, l, d, dist;
	for (i=0; i<Count; i++)
		Dir[i] = (Dir[i]*99)/100;
	if (RandConn) {
		BOOL slow = TRUE;
		for (i=0; i<Count && slow; i++) slow &= (Dir[i].Magnitude()<5);
		if (slow) {
			l=0; FORALLCONN(a,b) l++;
			if (l<=Count) Connect(rand()%Count, rand()%Count);
			else {
				l= rand()%l;
				FORALLCONN(a,b) if (!l--) Connect(a,b);
			}
		};
	}
	for (b=1; b<Count; b++)
		for (a=0; a<b; a++) {
			TSize v = Pos[b] - Pos[a];
			l = v.Magnitude();
			if (Attraction && Connected(a,b)) {
				d = l-DistA;
				if (!d) continue;
				dist = DistA;
			} else if (Repulsion) {
				d = l-DistR;
				if (d>=0) continue;
				dist=DistR;
			}
			else continue;
			while (!l) {
				v = TSize(rand()%9-4, rand()%9-4);
				l = v.Magnitude();
				d = l-dist;
			}
			v = scale( v, 2*d, dist*l);
			Dir[a] += v;
			Dir[b] -= v;
		}

	if (Random) for (i=0; i<Count; i++)
		Dir[i] += TSize(rand()%5-2, rand()%5-2);
	for (i=0; i<Count; i++)
		if (Dir[i].Magnitude()>50) Dir[i] /= 2;
	for (i=0; i<Count; i++)
		if (!Dragging || i!=Current || MouseConnect) Pos[i] += Dir[i];
	Invalidate();
}

void TTestWindow::ButtonDown(TPoint& p, BOOL right)
{
	if (!Dragging && !PreDrag) {
		MouseConnect=right;
		for (int i = Count-1; i>=0; i--) if (Rec[i].Contains(p)) {
			Current = Other = i;
			Dragging = TRUE;
			Last = Pos[Current];
			Relax();
			break;
		}
		SetCapture();
		TRect r = GetClientRect();
		ClientToScreen(r.TopLeft());
		ClientToScreen(r.BottomRight());
		::ClipCursor(&r);
		if (!Dragging) PreDrag = TRUE;
		SetCursor(::Module, MouseConnect ? (PreDrag ? IDC_GRASP : IDC_HOLD) : IDC_TIP);
//		SetCursor(::Module, MouseConnect ? IDC_HOLD : IDC_TIP);
		CurPos = p;
	}
}

void TTestWindow::ButtonUp( TPoint& p)
{
	if (PreDrag || Dragging) {
		ReleaseCapture();
		::ClipCursor(0);
		if (Dragging) {
			if (!MouseConnect) Pos[Current] += Dir[Current] += p - Last;
			else Connect(Other, Current);
			Relax();
		}
		PreDrag = Dragging = FALSE;
	}
	SetCursor(0,  IDC_ARROW);
}

void TTestWindow::EvMouseMove( UINT, TPoint& p)
{
	CurPos = p;
	if (PreDrag) for (int i = Count-1; i>=0; i--)
		if (Rec[i].Contains(p)) {
			Current = Other = i;
			Dragging = TRUE;
			PreDrag = FALSE;
			Last = Pos[Current];
			SetCursor(::Module, MouseConnect ? IDC_HOLD : IDC_TIP);
			Relax();
			break;
		}
	if (Dragging) {
		if (!MouseConnect) Pos[Current] += p - Last;
		else {
			Other = Current;
			for (int i = Count-1; i>=0; i--)
				if (i!=Current && Rec[i].Contains(p)) {Other = i; break;}
		}
		Last = p;
		Relax();
		if (!MouseConnect) {
			Last = Pos[Current];
			if (GetAsyncKeyState(VK_SHIFT)<0) {
				Dir[Current] += TSize( rand()%100-50, rand()%100-50);
				ButtonUp(p);
			}
		}
	}
	if (PreDrag) Relax();
}


void TTestWindow::AttrMenu()
{
	char tit[]= "0";
	TPopupMenu m;
	for (int i=1; i<10;i++) {
		*tit = '0'+i;
		m.AppendMenu( i==CurAttr ? MF_CHECKED:0, CM_ATTR+i, tit);
	}
	TPoint p;
	GetCursorPos(p);
	int mh = GetSystemMetrics(SM_CYMENU);
	p.x+=10;
	p.y -= CurAttr*mh-mh/2;
	SetTimer(1, 50);
	m.TrackPopupMenu( TPM_LEFTBUTTON, p, 0, *GetApplication()->GetMainWindow());
	KillTimer(1);
}

void TTestWindow::RepMenu()
{
	char tit[]= "0";
	TPopupMenu m;
	for (int i=1; i<10;i++) {
		*tit = '0'+i;
		m.AppendMenu( i==CurRep ? MF_CHECKED:0, CM_REP+i, tit);
	}
	TPoint p;
	GetCursorPos(p);
	int mh = GetSystemMetrics(SM_CYMENU);
	p.x+=10;
	p.y -= CurRep*mh-mh/2;
	SetTimer(1, 50);
	m.TrackPopupMenu( TPM_LEFTBUTTON, p, 0, *GetApplication()->GetMainWindow());
	KillTimer(1);
}

void TTestWindow::LSMenu()
{
	char *s="Save0";
	TMemoryDC dc;
	TBitmap* icon[6];
	for (int i=1; i<=5; i++) {
		s[4]='0'+i;
		if (LoadIcon(s)) {
			dc.SelectObject(*(icon[i]=new TBitmap(TScreenDC(), 32, 32)));
			dc.TextRect(0,0,32,32,TColor(GetSysColor(COLOR_MENU)));
			PaintIcon(dc);
			dc.RestoreBitmap();
		}
		else icon[i] = 0;
	}
	char tit[10];
	TPopupMenu m,a,b;
	m.AppendMenu( MF_POPUP, (UINT) (HMENU) a, "Load");
	m.AppendMenu( MF_POPUP, (UINT) (HMENU) b, "Save");
	for (i=1; i<=5;i++) {
		if (icon[i]) {
			a.AppendMenu( 0, CM_LOAD+i, *icon[i]);
			b.AppendMenu( 0, CM_SAVE+i, *icon[i]);
		} else {
			wsprintf( tit, "Slot %i", i);
			a.AppendMenu( MF_GRAYED, CM_LOAD+i, tit);
			b.AppendMenu( 0, CM_SAVE+i, tit);
		}
		if (i<5) {
			a.AppendMenu( MF_SEPARATOR);
			b.AppendMenu( MF_SEPARATOR);
		}
	}
	TPoint p;
	GetCursorPos(p); p.x+=10;
	SetTimer(1, 50);
	m.TrackPopupMenu( TPM_LEFTBUTTON, p, 0, *GetApplication()->GetMainWindow());
	for (i=1; i<=5; i++) delete icon[i];
	KillTimer(1);
}

//----------------------------------------------------------------------------

class TTestApp : public TApplication {
	public:
		TTestApp() : TApplication() {}
		void  InitMainWindow();
};

void  TTestApp::InitMainWindow()
{
	MainWindow = new TTestWindow();
	MainWindow->Attr.X=(::GetSystemMetrics(SM_CXSCREEN)-600)/2;
	MainWindow->Attr.Y=(::GetSystemMetrics(SM_CYSCREEN)-400)/2;
	MainWindow->Attr.W=600;
	MainWindow->Attr.H=400;
//	MainWindow->SetIcon(this, IDI_APP);
	MainWindow->SetIcon(0, 0);
}

//----------------------------------------------------------------------------

int OwlMain(int, char*[])
{
	randomize();
	return TTestApp().Run();
}