{$DEFINE noTest}

{$IFDEF Test}
  {$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+}
{$ELSE}
  {$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+}
{$ENDIF}

{$M 8192,0,655360}

(* Erstellt: Jan '94 *)
(* Letzte nderung: 02.07.95 *)

PROGRAM PasView;

USES
  Crt, Objects, WinDos, Strings;

TYPE
  TMenuItem = RECORD
    Name: String[20];
    Value: Word;
  END;

CONST
  Version = '1.5';

  cString  = 0;   IsString   = $0001;
  cComment1= 1;   IsComment1 = $0002;
  cComment2= 2;   IsComment2 = $0004;
  cSpace   = 3;   IsSpace    = $0008;
  cChar    = 4;   IsChar     = $0010;
  cReserve = 5;   IsReserved = $0020;
  cAsm     = 6;   IsAsm      = $0040;
  cNumber  = 7;   IsNumber   = $0080;
  cIdent   = 8;   IsIdent    = $0100;
  cSymbol  = 9;   IsSymbol   = $0200;
  cNorm    = 10;
  cShadow  = 11;
  cWin     = 12;
  cStat    = 13;
  cMenu    = 14;
  cMenuBar = 15;
  cInput   = 16;
  cFunc    = 17;
  cFuncNr  = 18;
  cError   = 19;

TYPE
  TColor = ARRAY[ cString..cError] OF Byte;

CONST
  col1: TColor = (
    16 * Blue      + LightMagenta,                    (* cString   *)
    16 * Blue      + LightGray,                       (* cComment1 *)
    16 * Blue      + LightGray,                       (* cComment2 *)
    16 * Blue      + White,                           (* cSpace    *)
    16 * Blue      + LightMagenta,                    (* cChar     *)
    16 * Blue      + Yellow,                          (* cReserve  *)
    16 * Blue      + LightGreen,                      (* cAsm      *)
    16 * Blue      + LightRed,                        (* cNumber   *)
    16 * Blue      + LightCyan,                       (* cIdent    *)
    16 * Blue      + LightCyan,                       (* cSymbol   *)
    16 * Black     + LightGray,                       (* cNorm     *)
    16 * Black     + DarkGray,                        (* cShadow   *)
    16 * LightGray + Black,                           (* cWin      *)
    16 * Cyan      + Black,                           (* cStat     *)
    16 * Magenta   + White,                           (* cMenu     *)
    16 * Black     + White,                           (* cMenuBar  *)
    16 * Cyan      + Black,                           (* cInput    *)
    16 * Cyan      + Black,                           (* cFunc     *)
    16 * Black     + LightGray,                       (* cFuncNr   *)
    16 * Red       + White);                          (* cError    *)

  col2: TColor = (
    16 * Blue      + LightCyan,                       (* cString   *)
    16 * Blue      + LightGray,                       (* cComment1 *)
    16 * Blue      + LightGray,                       (* cComment2 *)
    16 * Blue      + LightCyan,                       (* cSpace    *)
    16 * Blue      + LightCyan,                       (* cChar     *)
    16 * Blue      + LightGreen,                      (* cReserve  *)
    16 * Blue      + Yellow,                          (* cAsm      *)
    16 * Blue      + LightRed,                        (* cNumber   *)
    16 * Blue      + White,                           (* cIdent    *)
    16 * Blue      + White,                           (* cSymbol   *)
    16 * Black     + LightGray,                       (* cNorm     *)
    16 * Black     + DarkGray,                        (* cShadow   *)
    16 * LightGray + Black,                           (* cWin      *)
    16 * Cyan      + White,                           (* cStat     *)
    16 * Green     + White,                           (* cMenu     *)
    16 * Black     + White,                           (* cMenuBar  *)
    16 * Green     + Black,                           (* cInput    *)
    16 * LightGray + Blue,                            (* cFunc     *)
    16 * Black     + LightRed,                        (* cFuncNr   *)
    16 * Red       + White);                          (* cError    *)


  SyntaxMenuItems= 9;
  SyntaxMenu: ARRAY[ 0..SyntaxMenuItems-1] OF TMenuItem=(
    (Name: 'Reservierte Wrter'; Value: cReserve),
    (Name: 'Bezeichner'; Value: cIdent),
    (Name: 'Zahlen'; Value: cNumber),
    (Name: 'Zeichenketten'; Value: cString),
    (Name: 'Zeichenkonstanten'; Value: cChar),
    (Name: 'Sonderzeichen'; Value: cSymbol),
    (Name: '{ Kommentare }'; Value: cComment1),
    (Name: '(* Kommentare *)'; Value: cComment2),
    (Name: 'Assembler'; Value: cAsm));

  ColorMenuItems= 16;
  ColorMenu: ARRAY[ 0..ColorMenuItems-1] OF TMenuItem=(
    (Name: 'Rot'; Value: LightRed),
    (Name: 'Grn'; Value: LightGreen),
    (Name: 'Blau'; Value: LightBlue),
    (Name: 'Trkis'; Value: LightCyan),
    (Name: 'Pink'; Value: LightMagenta),
    (Name: 'Gelb'; Value: Yellow),
    (Name: 'Wei'; Value: White),
    (Name: 'Hellgrau'; Value: LightGray),
    (Name: 'Braun'; Value: Brown),
    (Name: 'Dunkelrot'; Value: Red),
    (Name: 'Dunkelgrn'; Value: Green),
    (Name: 'Dunkelblau'; Value: Blue),
    (Name: 'Dunkles Trkis'; Value: Cyan),
    (Name: 'Dunkles Pink'; Value: Magenta),
    (Name: 'Dunkelgrau'; Value: DarkGray),
    (Name: 'Schwarz'; Value: Black));

  TabMax = 8;
  TabWidth: Byte = 8;

  LastState: Word = 0;

  ResMax = 62;
  ResConst: ARRAY[ 0..ResMax-1] OF String[14]=(
    'ABSOLUTE', 'AND', 'ARRAY', 'ASM', 'ASSEMBLER', 'BEGIN', 'CASE',
    'CONST', 'CONSTRUCTOR', 'DESTRUCTOR', 'DIV', 'DO', 'DOWNTO', 'ELSE',
    'END', 'EXPORT', 'EXPORTS', 'EXTERNAL', 'FAR', 'FILE', 'FOR', 'FORWARD',
    'FUNCTION', 'GOTO', 'IF', 'IMPLEMENTATION', 'IN', 'INHERITED',
    'INLINE', 'INTERFACE', 'INTERRUPT', 'LABEL', 'LIBRARY', 'MOD', 'NEAR',
    'NIL', 'NOT', 'OBJECT', 'OF', 'OR', 'PACKED', 'PRIVATE', 'PROCEDURE',
    'PROGRAM', 'PUBLIC', 'RECORD', 'REPEAT', 'SET', 'SHL', 'SHR',
    'STRING', 'THEN', 'TO', 'TYPE', 'UNIT', 'UNTIL', 'USES', 'VAR',
    'VIRTUAL', 'WHILE', 'WITH', 'XOR');

  nul = '';  (* nicht im ASCII-Satz vorhanden*)

  ANSI: ARRAY[#0..#255] OF Char = (
    #0,#1,#2,#3,#4,#5,#6,#7,
    #8,#9,#10,#11,#12,#13,#14,#15,
    #16,#17,#18,#19,#20,#21,#22,#23,
    #24,#25,#26,#27,#28,#29,#30,#31,
    { 32}' ',{ 33}'!',{ 34}'"',{ 35}'#',{ 36}'$',{ 37}'%',{ 38}'&',{ 39}'''',
    { 40}'(',{ 41}')',{ 42}'*',{ 43}'+',{ 44}',',{ 45}'-',{ 46}'.',{ 47}'/',
    { 48}'0',{ 49}'1',{ 50}'2',{ 51}'3',{ 52}'4',{ 53}'5',{ 54}'6',{ 55}'7',
    { 56}'8',{ 57}'9',{ 58}':',{ 59}';',{ 60}'<',{ 61}'=',{ 62}'>',{ 63}'?',
    { 64}'@',{ 65}'A',{ 66}'B',{ 67}'C',{ 68}'D',{ 69}'E',{ 70}'F',{ 71}'G',
    { 72}'H',{ 73}'I',{ 74}'J',{ 75}'K',{ 76}'L',{ 77}'M',{ 78}'N',{ 79}'O',
    { 80}'P',{ 81}'Q',{ 82}'R',{ 83}'S',{ 84}'T',{ 85}'U',{ 86}'V',{ 87}'W',
    { 88}'X',{ 89}'Y',{ 90}'Z',{ 91}'[',{ 92}'\',{ 93}']',{ 94}'^',{ 95}'_',
    { 96}'`',{ 97}'a',{ 98}'b',{ 99}'c',{100}'d',{101}'e',{102}'f',{103}'g',
    {104}'h',{105}'i',{106}'j',{107}'k',{108}'l',{109}'m',{110}'n',{111}'o',
    {112}'p',{113}'q',{114}'r',{115}'s',{116}'t',{117}'u',{118}'v',{119}'w',
    {120}'x',{121}'y',{122}'z',{123}'{',{124}'|',{125}'}',{126}'~',{127}'',
    {128}nul,{129}nul,{130}',',{131}'',{132}'"',{133}nul,{134}'',{135}'',
    {136}'^',{137}nul,{138}nul,{139}'<',{140}'O',{141}nul,{142}nul,{143}nul,
    {144}nul,{145}'`',{146}'`',{147}'"',{148}'"',{149}'',{150}'-',{151}'',
    {152}'~',{153}nul,{154}nul,{155}'>',{156}nul,{157}nul,{158}nul,{159}'Y',
    {160}' ',{161}'',{162}'',{163}'',{164}nul,{165}'',{166}'|',{167}'',
    {168}'"',{169}nul,{170}'',{171}'',{172}'',{173}'-',{174}nul,{175}nul,
    {176}'',{177}'',{178}'',{179}nul,{180}'`',{181}'',{182}'',{183}'',
    {184}nul,{185}nul,{186}'',{187}'',{188}'',{189}'',{190}nul,{191}'',
    {192}'A',{193}'A',{194}'A',{195}'A',{196}'',{197}'',{198}'',{199}'',
    {200}'E',{201}'',{202}'E',{203}'E',{204}'I',{205}'I',{206}'I',{207}'I',
    {208}'D',{209}'',{210}'O',{211}'O',{212}'O',{213}'O',{214}'',{215}'x',
    {216}'',{217}'U',{218}'U',{219}'U',{220}'',{221}'Y',{222}nul,{223}'',
    {224}'',{225}'',{226}'',{227}'a',{228}'',{229}'',{230}'o',{231}'',
    {232}'',{233}'',{234}'',{235}'',{236}'',{237}'',{238}'',{239}'',
    {240}nul,{241}'',{242}'',{243}'',{244}'',{245}'o',{246}'',{247}'',
    {248}'',{249}'',{250}'',{251}'',{252}'',{253}'y',{254}nul,{255}'');

  StatStr: ARRAY[1..10] OF String[6] =
     ('Hilfe ', 'Sich  ', 'Sichtb', 'Caps. ', 'Farben', 'TabW  ',
      'Suchen', 'ChrSet', '      ', 'Quit');

  CapitalStr: ARRAY[0..3] OF String[6] =
     ('Gro  ', 'Klein ', 'Gr./Kl', 'Orig. ');

  CharSetStr: ARRAY[0..1] OF String[6] =
     ('ASCII ', 'ANSI  ');

  XCharStr: ARRAY[0..1] OF String[4] =
     ( '    ', ''#26' ');
  (* Space, Return, TabFirst, TabFollow *)

  ButtonCount: Byte = 0;
  MouseBut: Byte = 0;
  MouseX: Word = 0;
  MouseY: Word = 0;

  TimeOut: Word = 1092*3;  (* 1092 Ticks = 1 Minute *)
			   (* $0290 in nc.ini *)


  LineBuf: String = '';
  LinePos: LongInt = -1;
  LinePtr: PString = NIL;

  SearchStr: String[60] = '';
  DoSearch: Boolean = False;
  SearchX: Integer = 0;
  SearchY: Integer = 0;

  Capitals: Byte = 0;                    (* 0=Gro, 1=Klein, 2=Gr./Kl., 3=Original *)
  CharSet: Byte = 0;                     (* 0=ASCII, 1=ANSI *)
  XChar: Byte = 0;                       (* 0=Keine Anzeige, 1=Zeigen *)

  SyntaxChoice: Integer = 0;

  IsVGA: Boolean = FALSE;

  (* Keys *)

  kLeft   = #75;  kF1  = #59;  kShiftF1  = #84;  kBack  = #08;
  kRight  = #77;  kF2  = #60;  kShiftF2  = #85;  kEnter = #13;
  kUp     = #72;  kF3  = #61;  kShiftF3  = #86;  kEsc   = #27;
  kDown   = #80;  kF4  = #62;  kShiftF4  = #87;
  kPgUp   = #73;  kF5  = #63;  kShiftF5  = #88;  kAltF5 = #108;
  kPgDown = #81;  kF6  = #64;  kShiftF6  = #89;  kAltF6 = #109;
  kHome   = #71;  kF7  = #65;  kShiftF7  = #90;
  kEnd    = #79;  kF8  = #66;  kShiftF8  = #91;
  kIns    = #82;  kF9  = #67;  kShiftF9  = #92;
  kDel    = #83;  kF10 = #68;  kShiftF10 = #93;

  kCtrlPgUp = #132;
  kCtrlPgDn = #118;
  kCtrlLeft = #115;
  kCtrlRight= #116;

TYPE
  PLine = ^TLine;
  TLine = OBJECT( TObject)
    State: Word;
    Pos: LongInt;
    OrgLine: PString;
    CONSTRUCTOR Init( AState: Word; APos: LongInt; ALine: PString);
    FUNCTION Line: PString;
    PROCEDURE GetCLine( VAR n: String);
    DESTRUCTOR Done; VIRTUAL;
  END;
  PScrElem = ^TScrElem;
  TScrElem = RECORD
    c: Char;
    a: Byte
  END;
  PXStream = ^TXStream;
  TXStream = OBJECT( TBufStream)
    CONSTRUCTOR Init( FileName: FNameStr; Size: Word);
    PROCEDURE ReadLn( VAR Line: String);
  END;
  TCountryInfo = RECORD
     Date: Word; (* 0=MTJ, 1=TMJ, 2=JMT *)
     Currency: ARRAY[0..4] OF Char;
     Ch1000: Char;
     Dummy1: Byte;
     ChPoint: Char;
     Dummy2: Byte;
     ChDate: Char;
     Dummy3: Byte;
     ChTime: Char;
     Dummy4: Byte;
     CurrForm: Byte;
     Decimals: Byte;
     AmPm: Byte;
     Capitals: Pointer;
     Reserved: ARRAY[22..33] OF Byte;
  END;

VAR
  FileName: String[127];
  SkipMouse: Boolean;
  X, Y, XO, YO: Integer;
  SearchLen: Byte ABSOLUTE SearchStr;
  f: PCollection;
  TextSize: LongInt;
  TextName: String[20];
  TextTime: TDateTime;
  StateCount: Word;
  MouseXMin, MouseXMax, MouseYMin, MouseYMax: Word;
  Timer: Byte ABSOLUTE 0:$046c;
  PageSize: Word ABSOLUTE $0040:$004c;
  PageOffs: Word ABSOLUTE $0040:$004e;
  LastTime: Byte;
  LastBut: Byte;
  LastX, LastY: Word;
  TimeCount: Word;
  oWindMin, oWindMax: Word;
  col: TColor;
  CountryInfo: TCountryInfo;

(***************************************************************************)

PROCEDURE MakeDownCase( VAR Buf; Count: Word); ASSEMBLER;
ASM
	cld
	les	di,Buf
	mov	cx,Count
@1:	mov	al,es:[di]
	cmp	al,'A'
	jb	@2
	cmp	al,'Z'
	ja	@2
	add	al,'a'-'A'
	mov	es:[di],al
@2:	inc	di
	loop	@1
END;

(***************************************************************************)

PROCEDURE CursOff; ASSEMBLER;
asm
  mov ah,1
  mov cx,$2020
  int 10h
end;

(***************************************************************************)

PROCEDURE CursOn; ASSEMBLER;
ASM
  mov ax,$1200
  mov bl,$34
  int $10
  mov ah,1
  mov cx,$0607
  int 10h
END;

(***************************************************************************)

PROCEDURE SetPage( Page: Byte); ASSEMBLER;
ASM
  mov ah,5
  mov al,Page
  int $10
END;

(***************************************************************************)

PROCEDURE CheckVGA; ASSEMBLER;
ASM
	mov ax,$1a00
        int $10
        cmp al,$1a
        mov al,TRUE
        je  @END
        mov al,FALSE
@END:   mov IsVGA,al
END;

(***************************************************************************)

PROCEDURE WaitVRetrace; ASSEMBLER;
ASM
        cmp     IsVGA,TRUE
        jne     @END
        mov     dx,03DAH
@1:     in      al,dx
	and     al,08H
        jne     @1
@2:     in      al,dx
	and     al,08H
        je      @2
@END:
END;

(***************************************************************************)

PROCEDURE InitMouse; ASSEMBLER;
ASM
        mov     ax,3533h             (* Int 33 <> NIL *)
        int     21h
        mov     ax,es
        or      ax,bx
        je      @1
        xor     ax,ax                (* Reset *)
        int     33h
        or      ax,ax
        je      @1
        push    bx
	mov     ax,8                 (* MouseRows *)
        xor     cx,cx
        xor     dx,dx
	mov     dl,byte ptr [WindMax+1]
        shl     dx,3
        int     33h
        mov     ax,5                 (* GetMouseDown *)
        mov     bx,0
        int     33h
        mov     ax,6                 (* GetMouseUp *)
        mov     bx,0
        int     33h
	pop     ax
@1:     mov     ButtonCount,al
END;

(***************************************************************************)

PROCEDURE ShowMouse; ASSEMBLER;
ASM
        cmp     ButtonCount,0
        je      @1
        mov     ax,1
        int     33h
@1:
END;

(***************************************************************************)

PROCEDURE HideMouse; ASSEMBLER;
ASM
        cmp     ButtonCount,0
        je      @1
        mov     ax,2
        int     33h
@1:
END;

(***************************************************************************)

PROCEDURE ReadMouse; ASSEMBLER;
ASM
        cmp     ButtonCount,0
        je      @1
        mov     ax,3
	int     33h
        and     bl,3
        mov     MouseBut,bl
        shr     cx,3
        mov     MouseX,cx
        shr     dx,3
        mov     MouseY,dx
@1:
END;

(***************************************************************************)

PROCEDURE GetMouseDown( VAR Count, px, py: Word); ASSEMBLER;
ASM
        cmp     ButtonCount,0
        jne     @DoInt

        xor     bx,bx
        xor     cx,cx
        xor     dx,dx
        jmp     @Store

@DoInt: mov     ax,5
	mov     bx,0
	int     33h

@Store: les     di,Count
        mov     es:[di],bx
	shr     cx,3
        les     di,px
        mov     es:[di],cx
        shr     dx,3
        les     di,py
        mov     es:[di],dx
END;

(***************************************************************************)

PROCEDURE GetMouseUp( VAR Count, px, py: Word); ASSEMBLER;
ASM
        cmp     ButtonCount,0
        jne     @DoInt

        xor     bx,bx
        xor     cx,cx
        xor     dx,dx
        jmp     @Store

@DoInt: mov     ax,6
        mov     bx,0
        int     33h

@Store: les     di,Count
        mov     es:[di],bx
	shr     cx,3
        les     di,px
        mov     es:[di],cx
        shr     dx,3
        les     di,py
        mov     es:[di],dx
END;

(***************************************************************************)

PROCEDURE SetMouseStyle( AndMask, XorMask: Word); ASSEMBLER;
ASM
        cmp     ButtonCount,0
        je      @1
        mov     ax,0ah
        mov     bx,0
        mov     cx,AndMask
        mov     dx,XorMask
        int     33h
@1:
END;

(***************************************************************************)

CONSTRUCTOR TXStream. Init( FileName: FNameStr; Size: Word);
BEGIN
  inherited Init( FileName, stOpenRead, Size);
END;

(***************************************************************************)

PROCEDURE TXStream. ReadLn( VAR Line: String);
VAR Tail, source, dest: PChar;
    c: Char;
    Len: Byte ABSOLUTE Line;
BEGIN
  IF Status<>stOK THEN Exit;
  Source:= PChar(Buffer)+BufPtr;
  Tail:= PChar(Buffer)+BufEnd;
  dest:= @Line[1];
  Len:= 0;
  REPEAT
    IF Tail-Source>0 THEN BEGIN
      c:= source^;
      Inc( Source);
    END ELSE BEGIN
      BufPtr:= BufEnd;
      TBufStream.Read( c, 1);
      Source:= PChar(Buffer)+BufPtr;
      Tail:= PChar(Buffer)+BufEnd;
      IF Status<>stOK THEN Break;
    END;
    dest^:= c;
    Inc( dest);
    Inc( Len);
  UNTIL (c=#$A) OR (Len=255);
  BufPtr:= Source-PChar( Buffer);
  IF c=#$A THEN Dec( Len);
  IF Line[Len]=#$D THEN Dec( Len);
END;

(***************************************************************************)

PROCEDURE GetCountryInfo; ASSEMBLER;
ASM
        mov     ax,$3800
        lea     dx,CountryInfo
        int     $21
END;

(***************************************************************************)

FUNCTION DateStr( CONST t: TDateTime): String;
CONST o: ARRAY[0..2, 0..5] OF Byte =
  ((7,8,1,2,4,5),
   (7,8,4,5,1,2),
   (1,2,4,5,7,8));
VAR s: String[8];
BEGIN
  WITH CountryInfo, t DO BEGIN
    s[0]:= #8;
    s[3]:= ChDate; s[6]:= ChDate;
    s[o[Date,0]]:= Char( (Year mod 100) div 10 + Byte( '0'));
    s[o[Date,1]]:= Char( Year mod 10 + Byte( '0'));
    s[o[Date,2]]:= Char( Month div 10 + Byte( '0'));
    s[o[Date,3]]:= Char( Month mod 10 + Byte( '0'));
    s[o[Date,4]]:= Char( Day div 10 + Byte( '0'));
    s[o[Date,5]]:= Char( Day mod 10 + Byte( '0'));
  END;
  DateStr:= s;
END;

(***************************************************************************)

FUNCTION TimeStr( CONST t: TDateTime): String;
VAR s: String[7];
    h: Byte;
BEGIN
  WITH CountryInfo, t DO BEGIN
    s[0]:= #5;
    s[3]:= ChTime;
    h:= Hour;
    IF (AmPm AND 1)=0 THEN BEGIN
      s[0]:= #7;
      IF h>=12 THEN BEGIN
        Dec( h, 12);
        s[6]:= 'p';
      END ELSE s[6]:= 'a';
      s[7]:= 'm';
      IF h=0 THEN h:= 12;
    END;
    s[1]:= Char( h div 10 + Byte( '0'));
    s[2]:= Char( h mod 10 + Byte( '0'));
    s[4]:= Char( Min div 10 + Byte( '0'));
    s[5]:= Char( Min mod 10 + Byte( '0'));
  END;
  TimeStr:= s;
END;

(***************************************************************************)

PROCEDURE MakeLocal( VAR x, y: Word);
BEGIN
  Dec( x, Lo( WindMin)-1);
  Dec( y, Hi( WindMin)-1);
END;

(***************************************************************************)

FUNCTION InWindow( x, y: Word): Boolean;
BEGIN
  InWindow:= (x<=Lo(WindMax)) AND (y<Hi(WindMax)) AND
             (x>=Lo(WindMin)) AND (y>=Hi(WindMin));
END;

(***************************************************************************)

PROCEDURE Shadow( x, y: Integer);
VAR o: ^Byte;
BEGIN
  o:= Ptr( $B800, (80*y+x)*2+1);
  o^:= col[cShadow];
  Inc( o, 2);
  o^:= col[cShadow];
END;

(***************************************************************************)

PROCEDURE CenterWin( w, h: Integer);
VAR s: String;
    i, x, y: Integer;
BEGIN
  HideMouse;
  x:= (Lo(WindMax)-w) div 2;
  y:= (Hi(WindMax)-h) div 2;
  WindMin:= y shl 8 + x;
  WindMax:= (y+h) shl 8 + x+w;
  GotoXY( 1, 1);
  s:= ' '; FOR i:= 1 TO w DO s:= s+' ';
  Write( s);
  s:= '   '; FOR i:= 1 TO w-7 DO s:= s+''; s:= s+'   ';
  Write( s);
  s:= '   '; FOR i:= 1 TO w-7 DO s:= s+' '; s:= s+'   ';
  FOR i:= 1 TO h-4 DO Write( s);
  s:= '   '; FOR i:= 1 TO w-7 DO s:= s+''; s:= s+'   ';
  Write( s);
  s:= ' '; FOR i:= 1 TO w DO s:= s+' ';
  Write( s);
  FOR i:= x+2 TO x+w DO Shadow( i, y+h);
  FOR i:= y+1 TO y+h DO Shadow( x+w+1, i);
  GotoXY( 1, 2);
  ShowMouse;
END;

(***************************************************************************)

PROCEDURE RestoreWin;
BEGIN
  WindMin:= oWindMin;
  WindMax:= oWindMax;
END;

(***************************************************************************)

PROCEDURE WriteCenter( s: String);
BEGIN
  HideMouse;
  GotoXY( (Lo(WindMax)-Lo(WindMin)-Length(s)) div 2+2, WhereY);
  WriteLn( s);
  ShowMouse;
END;

(***************************************************************************)

PROCEDURE ShowRead;
BEGIN
  TextAttr:= col[ cWin];
  CenterWin( 26, 7);
  WriteCenter( ' Anzeige ');
  WriteCenter( 'Lesen der Datei');
  WriteCenter( TextName);
  RestoreWin;
END;

(***************************************************************************)

PROCEDURE ShowStatus;
VAR p: Integer;
BEGIN
  HideMouse;
  TextAttr:= col[ cStat];
  GotoXY( 76, 1);
  IF f^.Count>Hi(WindMax)-1
    THEN p:= PLine( f^.At(y+Hi(WindMax)-2))^. Pos*100 div TextSize
    ELSE p:= 100;
  Write( p:3, '%');
  ClrEol;
  ShowMouse;
END;

(***************************************************************************)

PROCEDURE ShowFunc;
VAR i: Integer;
    s: String;
BEGIN
  StatStr[4]:= CapitalStr[ Capitals];
  Str( TabWidth:2, s);
  StatStr[6]:= Copy( StatStr[6], 1, 4)+s;
  StatStr[8]:= CharSetStr[ CharSet];
  HideMouse;
  GotoXY( 1, Hi(WindMax)+1);
  FOR i:= 1 TO 10 DO BEGIN
    TextAttr:= col[ cFuncNr];
    IF i>1 THEN Write( ' ');
    Write( i);
    TextAttr:= col[ cFunc];
    Write( StatStr[ i]);
  END;
  ClrEol;
  ShowMouse;
END;

(***************************************************************************)

PROCEDURE ShowLine( p: PScrElem; s: String);
VAR i, l: Integer;
    Len: Byte ABSOLUTE s;
    a: Byte;
BEGIN
  Move( s[1], p^, Len);
  Len:= Len shr 1;
  Inc( p, Len);
  FOR i:= 1 TO Lo( WindMax)+1-Len DO BEGIN
    p^.c:= ' ';
    p^.a:= col[ cSpace];
    Inc( p);
  END;
END;

(***************************************************************************)

PROCEDURE GetCLine( z: Word; VAR s: String);
VAR p: PLine;
    i: Integer;
BEGIN
  WITH f^ DO
    IF (z>=0) AND (z<Count) THEN BEGIN
      IF StateCount<Count THEN BEGIN
	p:= Items^[ StateCount];
        LastState:= p^. State;
	WHILE StateCount<=z DO BEGIN
	  p^. GetCLine( s);
          Inc( StateCount);
          IF StateCount<Count THEN BEGIN
            p:= Items^[ StateCount];
            p^. State:= LastState;
          END;
        END;
      END;
      p:= Items^[ z];
      p^. GetCLine( s);
      IF DoSearch AND (z=SearchY) THEN
        FOR i:= SearchX TO SearchX+SearchLen-1 DO
          s[2*i]:= Char(col[cStat]);
    END
      ELSE s:= '';
END;

(***************************************************************************)

PROCEDURE ShowFile;
VAR i, z, pd: Word;
    s: String;
    p: PScrElem;
BEGIN
  IF x>=254-2*Lo( WindMax) THEN x:= 254-2*Lo( WindMax);
  IF x<0 THEN x:= 0;
  IF y>f^.Count-Hi( WindMax)+1 THEN y:= f^.Count-Hi( WindMax)+1;
  IF y<0 THEN y:= 0;

  HideMouse;
  TextAttr:= col[ cSpace];
  z:= y;
  pd:= Lo( WindMax)+1;
  p:= Ptr( $B800, 0);
  IF (xo=x) AND (y=yo+1) THEN BEGIN
    Inc( WindMin, $0100);
    Dec( WindMax, $0100);
    GotoXY( 1, 1);
    WaitVRetrace;
    DelLine;
    Inc( p, Hi(WindMax)*pd);
    GetCLine( y+Hi(WindMax)-1, s);
    ShowLine( p, Copy( s, x+1, 2*(Lo(WindMax)+1)));
    Dec( WindMin, $0100);
    Inc( WindMax, $0100);
  END
  ELSE IF (xo=x) AND (y=yo-1) THEN BEGIN
    Inc( WindMin, $0100);
    Dec( WindMax, $0100);
    GotoXY( 1, 1);
    WaitVRetrace;
    InsLine;
    Inc( p, pd);
    GetCLine( y, s);
    ShowLine( p, Copy( s, x+1, 2*(Lo(WindMax)+1)));
    Dec( WindMin, $0100);
    Inc( WindMax, $0100);
  END ELSE
  FOR i:= 0 TO Hi(WindMax)-2 DO BEGIN
    Inc( p, pd);
    GetCLine( z, s);
    ShowLine( p, Copy( s, x+1, 2*(Lo(WindMax)+1)));
    Inc( z);
  END;
  ShowMouse;
  xo:= x;
  yo:= y;
END;

(***************************************************************************)

PROCEDURE InitScreen;
BEGIN
  TextAttr:= col[ cStat];
  GotoXY( 1, 1);
  HideMouse;
  WITH TextTime DO
    Write( 'PASCAL: ', TextName, '  ',
	   DateStr( TextTime), ' ', TimeStr( TextTime),'  ',
	   TextSize, ' Bytes  ', f^.Count, ' Zeilen ');
  ClrEol;
  ShowMouse;
  ShowFunc;
  ShowFile;
  ShowStatus;
  MouseXMin:= Lo( WindMax) div 3;
  MouseXMax:= Lo( WindMax) * 2 div 3;
  MouseYMin:= Hi( WindMax) div 3;
  MouseYMax:= Hi( WindMax) * 2 div 3;
END;

(***************************************************************************)

PROCEDURE Blanker;
CONST
  Stars=30;
  Nova=8;
  s1: TScrElem=( c: ''; a: LightCyan);
  s2: TScrElem=( c: ''; a: White);
TYPE
  TStar= RECORD
	   p: PScrElem;
           t: Word
         END;
VAR mx, my, i, s, Time: Word;
    Star: ARRAY[ 0..Stars-1] OF TStar;
    ch: Char;
BEGIN
  HideMouse;
  TextAttr:= Cyan;
  SetPage( 1);
  FillChar( Mem[ $B800:PageOffs], PageSize, 0);
  FillChar( Star, SizeOf(Star), 0);
  ReadMouse;
  mx:= MouseX; my:= MouseY; s:= 0;
  REPEAT
    FOR i:= 0 TO s DO
    WITH Star[i] DO BEGIN
      Inc( t);
      CASE t OF
	1: p:= PScrElem(Ptr( $B800, (Random( PageSize) and not 1)+PageOffs));
        2: p^:= s1;
        31: p^:= s2;
        32: p^.c:= '';
        33: IF Random(Nova)>0 THEN t:= 37 ELSE p^.c:= '';
        34: p^.c:= '';
        35: p^.c:= '';
        36: p^.c:= '';
	38: p^.c:= ' ';
	39: t:= 0;
      END;
    END;
    Time:= Timer; REPEAT UNTIL Timer<>Time;
    Time:= Timer; REPEAT UNTIL Timer<>Time;
    IF s<Stars-1 THEN Inc( s);
    ReadMouse;
  UNTIL (MouseX<>mx) OR (MouseY<>my) OR (MouseBut>0) OR KeyPressed;
  WHILE KeyPressed DO ch:= ReadKey;
  SetPage( 0);
  ShowMouse;
END;
(***************************************************************************)

PROCEDURE Update;
BEGIN
  ReadMouse;
  IF (LastBut<>MouseBut) OR (LastX<>MouseX) OR (LastY<>MouseY) THEN BEGIN
    LastBut:= MouseBut;
    LastX:= MouseX;
    LastY:= MouseY;
    IF (MouseX>Lo(WindMax)-2) AND (MouseY=0)
      THEN TimeCount:= TimeOut-3
      ELSE TimeCount:= 0;
  END;
  IF (MouseX>Lo(WindMax)-2) AND (MouseY=Hi(WindMax)) THEN TimeCount:= 0;
  IF Timer=LastTime THEN Exit;
  Inc( TimeCount, byte(Timer-LastTime));
  IF TimeCount>TimeOut THEN BEGIN
    Blanker;
    TimeCount:= 0;
  END;
  LastTime:= Timer;
END;

(***************************************************************************)

FUNCTION GetSwitches(  SwX, SwY, SwWidth, SwCount: Integer): Byte;
VAR Count, px, py, mxo, myo: Word;
    func: Byte;
BEGIN
  GetSwitches:= 0;
  IF ButtonCount=0 THEN Exit;
  GetMouseUp( Count, px, py);   (* reset *)
  GetMouseDown( Count, px, py);
  MakeLocal( px, py);
  IF (Count=0) OR (py<>SwY) THEN Exit;
  Func:= word(px-SwX) div SwWidth;
  IF (Func<0) OR (Func>=SwCount) THEN Exit;
  REPEAT
    Update;
    MakeLocal( MouseX, MouseY);
    IF (mxo<>MouseX) OR (myo<>MouseY) THEN BEGIN
      mxo:= MouseX; myo:= MouseY;
      IF (MouseY=SwY) AND (word(MouseX-SwX) div SwWidth=Func)
        THEN SetMouseStyle( $FF00, $77FB)
	ELSE SetMouseStyle( $FFFF, $7700);
    END;
    GetMouseUp( Count, px, py);
    MakeLocal( px, py);
  UNTIL Count>0;
  SetMouseStyle( $FFFF, $7700);
  IF (py=SwY) AND (word(px-SwX) div SwWidth=Func)
    THEN GetSwitches:= Func+1
    ELSE GetSwitches:= $FF;
END;

(***************************************************************************)

FUNCTION GetFunc: Byte;
BEGIN
  GetFunc:= GetSwitches( 0, Hi( WindMax)+1, 8, 10);
END;

(***************************************************************************)

PROCEDURE Wait;
VAR c, x, y: Word;
    ch: Char;
BEGIN
  REPEAT
    Update;
    GetMouseDown( c, x, y);
  UNTIL (c>0) OR KeyPressed;
  WHILE KeyPressed DO ch:= ReadKey;
  IF c>0 THEN REPEAT
    GetMouseUp( c, x, y);
  UNTIL (c>0);
END;

(***************************************************************************)

PROCEDURE ShowHelp;
BEGIN
  TextAttr:= col[ cWin];
  CenterWin( 74, 19);
  WriteCenter( ' Hilfe ');
  WriteCenter( 'Der Pascal-Betrachter, Version '+Version);
  WriteCenter( 'Copyright (C) 1994-95, Bert Schnwlder');
  WriteLn;
  WriteCenter( 'BEWEGEN:               '#32'         FUNKTIONSTASTEN:                ');
  WriteCenter( 'Spalte links    ^S  o. '#27'             F1  Hilfe                ');
  WriteCenter( 'Spalte rechts   ^D  o. '#26'             F2  Konfiguration sichern');
  WriteCenter( 'Zeile oben      ^E  o. '#24'             F3  Steuerzeichen sichtb.');
  WriteCenter( 'Zeile unten     ^X  o. '#25'             F4  Schreibweise ndern  ');
  WriteCenter( 'Seite oben      ^R  o. PgUp'#32'         F5  Syntaxfarben ndern  ');
  WriteCenter( 'Seite unten     ^C  o. PgDn'#32'   Shift-F5  Hintergrundfarbe     ');
  WriteCenter( 'Dateianfang   Home  o.^PgUp'#32'         F6  Tabulatorweite ndern');
  WriteCenter( 'Dateiende      End  o.^PgDn'#32'         F7  Suchen               ');
  WriteCenter( 'Schnell links         ^'#27'       Shift-F7  Weitersuchen         ');
  WriteCenter( 'Schnell rechts        ^'#26'             F8  ASCII/ANSI Modus     ');
  WriteCenter( '                       '#32'            F10  Ende                ');


  Wait;
  RestoreWin;
  ShowFile;
END;

(***************************************************************************)

PROCEDURE ShowError( s1, s2: String);
VAR l: Integer;
BEGIN
  IF Length(s1)>Length(s2) THEN l:=Length(s1) ELSE l:=Length(s2);
  TextAttr:= col[ cError]; l:= l+14;
  CenterWin( l, 7);
  WriteCenter( ' Fehler ');
  WriteCenter( s1);
  WriteCenter( s2);
  TextAttr:= col[ cWin];
  GotoXY( l div 2 - 1, WhereY);
  Write( ' OK ');
{  REPEAT}
{    Update;}
{  UNTIL (GetSwitches( 39-1, WhereY-1, 4, 1)=1) OR KeyPressed;}
{  WHILE KeyPressed DO ReadKey;}
  Wait;
  RestoreWin;
END;

(***************************************************************************)

PROCEDURE CalcColor( VAR c: Byte); ASSEMBLER;
ASM
      mov al,0
      mov dx,LastState
@1:   shr dx,1
      jc @2
      inc al
      cmp al,16
      jl @1
      mov al,cNorm
@2:   les di,c
      mov es:[di],al
END;

(***************************************************************************)

function CmpString(Key1, Key2: Pointer): Integer; assembler;
asm
        PUSH    DS
        CLD
        LDS     SI,Key1
        LES     DI,Key2
        LODSB
        MOV     AH,ES:[DI]
        INC     DI
        MOV     CL,AL
        CMP     CL,AH
	JBE     @1
        MOV     CL,AH
@1:     XOR     CH,CH
        REP     CMPSB
        JE      @2
        MOV     AL,DS:[SI-1]
        MOV     AH,ES:[DI-1]
@2:     SUB     AL,AH
        CBW
        POP     DS
end;

(***************************************************************************)

FUNCTION CheckReserved( VAR s: String): Boolean;
VAR a, b, m, i: Integer;
BEGIN
  CheckReserved:= True;
  a:= 0; b:= ResMax-1;
  WHILE (a<=b) DO BEGIN
    m:= (a+b) shr 1;
    i:= CmpString( @ResConst[m], @s);
    IF i<0 THEN a:= m+1 ELSE BEGIN
     b:= m-1;
     IF i=0 THEN Exit;
    END;
  END;
  CheckReserved:= False;
END;

(***************************************************************************)

PROCEDURE CalcWord( VAR s: String; i: Byte; VAR LenW, LenC: Byte);
CONST Comm2Start= Byte('(')+256*byte('*');
      Comm2End= Byte('*')+256*byte(')');
type pword = ^word;
VAR LenS: Byte ABSOLUTE s;
    w: String;
    j: Integer;
    ss, c: Char;
    sw: Word;
BEGIN
  LenW:= 0;
  LenC:= 0;
  ss:= s[i];
  sw:= PWord( @s[i])^;

  IF LastState AND IsString>0 THEN BEGIN
    IF ss='''' THEN BEGIN
      LastState:= LastState AND not IsString;
      LenC:=1;
    END;
    exit;
  END;

  IF LastState AND IsComment1>0 THEN BEGIN
    IF ss='}' THEN BEGIN
      LastState:= LastState AND NOT IsComment1;
      LenC:= 1;
    END;
    exit;
  END;

  IF LastState AND IsComment2>0 THEN BEGIN
    IF sw=Comm2End THEN BEGIN
      LastState:= LastState AND NOT IsComment2;
      LenW:= 1;
      LenC:= 2;
    END;
    exit;
  END;

  IF ss='''' THEN BEGIN
    LastState:= LastState OR IsString;
    LenW:= 1;
    WHILE (LenW<LenS) AND (s[i+LenW]<>'''') DO Inc( LenW);
    exit;
  END;

  IF ss='{' THEN BEGIN
    LastState:= LastState OR IsComment1;
    exit;
  END;

  IF sw=Comm2Start THEN BEGIN
    LastState:= LastState OR IsComment2;
    LenW:= 1;
    exit;
  END;

  IF ss='#' THEN BEGIN
    LastState:= LastState OR IsChar;
    LenW:= 1;
    WHILE (LenW<LenS) AND (UpCase(s[i+LenW]) IN ['0'..'9','A'..'F', '$'])
      DO Inc( LenW);
    Dec( LenW);
    exit;
  END;

  IF (ss in [' ', #9]) THEN BEGIN
    LastState:= LastState OR IsSpace;
    LenW:= 1;
    WHILE (LenW<LenS) AND (s[i+LenW] in [' ', #9])
      DO Inc( LenW);
    Dec( LenW);
    exit;
  END;

  IF ss='$' THEN BEGIN
    LastState:= LastState OR IsNumber;
    LenW:= 1;
    WHILE (LenW<LenS) AND (UpCase(s[i+LenW]) IN ['0'..'9','A'..'F'])
      DO Inc( LenW);
    Dec( LenW);
    exit;
  END;

  IF ss in ['0'..'9'] THEN BEGIN
    LastState:= LastState OR IsNumber;
    LenW:= 1;
    c:= UpCase(s[i+LenW]);
    WHILE (LenW<LenS) AND (c in ['0'..'9', '.', 'e', 'E'])
      DO BEGIN
        IF (c='.') AND (s[i+LenW+1]='.') THEN Break;
        Inc( LenW);
        c:= UpCase(s[i+LenW]);
      END;
    Dec( LenW);
    exit;
  END;

  IF UpCase(ss) IN ['A'..'Z', '_', '@'] THEN BEGIN
    LenW:= 1;
    w:= UpCase(ss);
    c:=UpCase(s[i+LenW]);
    WHILE (LenW+i<=LenS) AND (c in ['0'..'9', 'A'..'Z', '_'])
      DO BEGIN
        Inc( LenW);
        w[LenW]:= c;
        c:=UpCase(s[i+LenW]);
      END;
    w[0]:= Char(LenW);
    IF not CheckReserved(w) THEN LastState:= LastState OR IsIdent
    ELSE BEGIN
      LastState:= LastState OR IsReserved;
      IF w='END' THEN LastState:= LastState AND NOT IsAsm ELSE
        IF LastState AND IsAsm>0 THEN LastState:= LastState AND NOT IsReserved;
      IF LastState AND IsAsm = 0 THEN
        IF Capitals=0 THEN Move( w[1], s[i], LenW) ELSE
        IF Capitals=1 THEN MakeDownCase( s[i], LenW) ELSE
        IF Capitals=2 THEN BEGIN
          s[i]:= UpCase(s[i]); MakeDownCase( s[i+1], LenW) END;
      IF w='ASM' THEN LastState:= LastState OR IsAsm;
    END;
    Dec( LenW);
    exit;
  END;

  LastState:= LastState OR IsSymbol;
END;

(***************************************************************************)

FUNCTION TLine. Line: PString;
VAR i: Integer;
    s, d: PChar;
BEGIN
  IF LinePos<>Pos THEN BEGIN
    IF (CharSet=0) OR (OrgLine=NIL) THEN LinePtr:= OrgLine
    ELSE BEGIN
      LinePtr:= @LineBuf;
      s:= PChar(OrgLine); d:= PChar(LinePtr);
      FOR i:= 0 TO Length( OrgLine^) DO BEGIN
        d^:= ANSI[s^];
        Inc( d); Inc( s);
      END;
    END;
    LinePos:= Pos;
  END;
  Line:= LinePtr;
END;

(***************************************************************************)

PROCEDURE TLine. GetCLine( VAR n: String);
VAR i, l: Integer;
    Color, LenW, LenC: Byte;
    oState: Word;
    ps, pn: ^Char;
    CurLine: String;
    t: Char;
BEGIN
  IF Line<>NIL THEN BEGIN
    CurLine:= Line^;
    CurLine[Length(CurLine)+1]:= #0;              (* V1.22 *)
    pn:= @n;
    ps:= @CurLine;
    n[0]:= #0;
    LenW:= 0;
    LenC:= 0;
    l:= 0;
    LastState:= State;
    oState:= LastState;
    CalcColor( Color);
    FOR i:= 1 TO Length( CurLine) DO BEGIN
      IF LenW=0 THEN LastState:=
	LastState AND not (IsSpace+IsString+IsNumber+IsChar+IsReserved+IsIdent+IsSymbol);
      IF LenW=0 THEN CalcWord( CurLine, i, LenW, LenC)
	 ELSE Dec( LenW);
      IF LenC=0 THEN
	IF oState<>LastState THEN BEGIN
	  CalcColor( Color);
	  oState:= LastState;
	END
	ELSE Dec( LenC);
      Inc( ps);
      IF ps^<>#9 THEN BEGIN
	Inc( pn);
	IF ps^<>' ' THEN pn^:= ps^ ELSE pn^:= XCharStr[ XChar, 1];
	Inc( pn);
	pn^:= Char(col[Color]);
	Inc( l);
      END ELSE BEGIN
	t:= XCharStr[ XChar, 3];
	REPEAT
	  Inc( pn);
	  pn^:= t;
	  t:= XCharStr[ XChar, 4];
	  Inc( pn);
	  pn^:= Char(col[Color]);
	  Inc( l);
	  IF l>126 THEN Break;
	UNTIL (l mod TabWidth)=0;
      END;
      IF l>126 THEN Break;
    END;
    n[0]:= Char(2*l);
  END
  ELSE n:= '';
  IF XChar=1 THEN n:= n+ XCharStr[ XChar, 2]+Char(col[cSpace]);
END;

(***************************************************************************)

CONSTRUCTOR TLine. Init( AState: Word; APos: LongInt; ALine: PString);
BEGIN
  TObject. Init;
  State:= AState;
  Pos:= APos;
  OrgLine:=ALine;
END;

(***************************************************************************)

DESTRUCTOR TLine. Done;
BEGIN
  IF OrgLine<>NIL THEN DisposeStr( OrgLine);
  TObject. Done;
END;

(***************************************************************************)

PROCEDURE ReadFile;
VAR XStream: PXStream;
    fi: File of Byte;
    s: String;
    i, j, p: Word;
    r: LongInt;
    prz, przn: Integer;
    oMode: Word;
BEGIN
  ShowRead;
  oMode:= FileMode; FileMode:=0;
  Assign( fi, FileName);
  Reset( fi);
  FileMode:= oMode;
  IF IOResult<>0 THEN BEGIN
    ShowError( 'Kann Datei nicht ffnen:', FileName);
    Halt( 1);
  END;
  TextSize:= FileSize( fi);
  GetFTime( fi, r); UnPackTime( r, TextTime);
  Close(fi);

  New( XStream, Init( FileName, 4096));

  StateCount:= 0;
  i:=0; r:= 0;
  WHILE XStream^.Status=stOK DO BEGIN
    Inc(i);
    XStream^. ReadLn( s);
    IF MaxAvail<1024+i*4 THEN BEGIN
      InitScreen;
      ShowError( 'Kann Datei nicht komplett laden:', 'Zuwenig Speicher!');
      Break;
    END;
    IF i=MaxCollectionSize THEN BEGIN
      InitScreen;
      ShowError( 'Kann Datei nicht komplett laden:', 'Zuviele Zeilen!');
      Break;
    END;
    Inc( r, 2+Byte(s[0]));
    IF Length(s)>127 THEN BEGIN
      s[0]:=#127;
      f^. Insert( New( PLine, Init( 0, r, NewStr((s)))));
      InitScreen;
      ShowError( 'Kann Datei nicht komplett laden:', 'Zeile zu lang');
      Break;
    END;
    f^. Insert( New( PLine, Init( 0, r, NewStr((s)))));
    IF (i>Hi(WindMax)) AND (StateCount=0) THEN BEGIN
      InitScreen;
      IF TextSize>20000 THEN
        ShowRead;
    END;
    IF TextSize>20000 THEN BEGIN
      prz:=r*100 div TextSize;
      IF przn<>prz THEN BEGIN
        Str( prz, s);
        WriteCenter( s+'%');
        GotoXY( 1, WhereY-1);
        przn:= prz;
      END;
    END;
  END;
  Dispose( XStream, Done);
END;

(***************************************************************************)

FUNCTION ReadStr( VAR s: String; l: Word): Boolean;
VAR mb, mx, my: Word;
    wx, wy: Word;
    Curs: Word;
    i: Word;
    c: Char;
    Ok, Cancel, First, WasInWindow: Boolean;
BEGIN
  wx:= WhereX; wy:= WhereY;
  Ok:= False; Cancel:= False; First:= True;
  Curs:= 0;
  CursOn;
  REPEAT
    TextAttr:= col[ cInput];
    GotoXY( wx, wy);
    HideMouse;
    FOR i:= 1 TO l DO
      IF i<=Length(s) THEN Write(s[i]) ELSE Write(' ');
    ShowMouse;
    GotoXY( wx+Curs, wy);
    REPEAT
      Update;
      GetMouseDown( mb, mx, my);
    UNTIL (mb>0) OR KeyPressed;
    IF mb>0 THEN BEGIN
      IF InWindow( mx, my) THEN REPEAT
        Update;
        MakeLocal( MouseX, MouseY);
        IF (MouseY=wy) AND (MouseX>=wx) AND (MouseX<wx+l) THEN BEGIN
          Curs:= MouseX-wx;
          IF Curs>Length(s) THEN Curs:= Length(s);
          GotoXY( wx+Curs, wy);
        END;
        GetMouseUp( mb, mx, my);
      UNTIL (mb>0)
      ELSE BEGIN
        CursOff; WasInWindow:= False;
        REPEAT
          Update;
          IF InWindow( MouseX, MouseY) THEN
            IF not WasInWindow THEN BEGIN CursOn; WasInWindow:= True END ELSE
          ELSE
            IF WasInWindow THEN BEGIN CursOff; WasInWindow:= False END;
          GetMouseUp( mb, mx, my);
        UNTIL (mb>0);
        Cancel:= not InWindow( mx, my);
      END;
      First:= False;
    END;
    IF KeyPressed THEN BEGIN
      c:= ReadKey;
      IF c=#0 THEN CASE ReadKey OF
        kLeft: IF Curs>0 THEN Dec( Curs);
        kRight: IF Curs<Length(s) THEN Inc( Curs);
        kHome: Curs:= 0;
        kEnd: Curs:= Length(s);
        kDel: Delete( s, Curs+1, 1);
        kF10: Cancel:= True;
      END
      ELSE CASE c OF
        kESC: Cancel:= True;
        kEnter: Ok:= True;
        kBack: IF Curs>0 THEN BEGIN
          Delete( s, Curs, 1);
          Dec( Curs);
        END;
        ^S: IF Curs>0 THEN Dec( Curs);
        ^D: IF Curs<Length(s) THEN Inc( Curs);
        ELSE IF (c>=' ') AND (Curs<l) THEN BEGIN
          IF First THEN s:= '';
          Insert( c, s, Curs+1);
          Inc( Curs);
        END;
      END;
      First:= False;
    END;
  UNTIL Ok OR Cancel;
  CursOff;
  ReadStr:= Ok;
END;

(***************************************************************************)

FUNCTION UpStr( s: String): String;
VAR i: Integer;
BEGIN
  FOR i:=1 TO Length( s) DO
    CASE s[i] OF
      'a'..'z': Dec( s[i], Byte('a')-Byte('A'));
      '': s[i]:= '';
      '': s[i]:= '';
      '': s[i]:= '';
      '': s[i]:= '';
      '': s[i]:= '';
      '': s[i]:= '';
      '': s[i]:= '';
      '': s[i]:= '';
    END;
  UpStr:= s;
END;

(***************************************************************************)

PROCEDURE SearchAgain;
VAR i: Integer;
    s: String[80];
BEGIN
  IF SearchStr='' THEN Exit;
  s:= UpStr( SearchStr);
  SearchY:= y+1;
  WHILE (SearchY<f^. Count) DO WITH PLine(f^. Items^[SearchY])^ DO BEGIN
    IF Line<>NIL THEN BEGIN
      SearchX:= System.Pos( s, UpStr( Line^));
      IF SearchX>0 THEN Break;
    END;
    SearchX:= 0;
    Inc( SearchY);
  END;
  IF SearchX=0 THEN BEGIN
    ShowFile;
    ShowError( 'Konnte Zeichenkette nicht finden:','"'+SearchStr+'"');
    ShowFile;
    Exit;
  END;
  IF SearchX+SearchLen>80 THEN x:= (SearchX+SearchLen-80)*2
                          ELSE x:= 0;
  y:= SearchY;
  xo:= x;
  yo:= y;
  DoSearch:= True;
  ShowFile;
END;

(***************************************************************************)

PROCEDURE Search;
VAR Ok: Boolean;
BEGIN
  TextAttr:= col[ cWin];
  CenterWin( 69, 6);
  WriteCenter( ' Suchen ');
  GotoXY( 6, WhereY); WriteLn( 'Suche nach der Zeichenkette:');
  GotoXY( 6, WhereY);
  Ok:= ReadStr( SearchStr, SizeOf( SearchStr)-1);
  RestoreWin;
  ShowFile;
  IF Ok AND (SearchStr<>'') THEN SearchAgain;
END;

(***************************************************************************)

PROCEDURE NextCapitals;
BEGIN
  IF Capitals=3 THEN Capitals:= 0 ELSE Inc( Capitals);
  ShowFunc;
  ShowFile;
END;

(***************************************************************************)

PROCEDURE NextCharSet;
BEGIN
  CharSet:= 1-CharSet;
  ShowFunc;
  ShowFile;
END;

(***************************************************************************)

PROCEDURE NextXChar;
BEGIN
  XChar:= 1-XChar;
  ShowFunc;
  ShowFile;
END;

(***************************************************************************)

PROCEDURE NextTabWidth( tw: Integer);
BEGIN
  TabWidth:= tw;
  IF TabWidth<1 THEN TabWidth:= TabMax;
  IF TabWidth>TabMax THEN TabWidth:= 1;
  ShowFunc;
  ShowFile;
END;

(***************************************************************************)

PROCEDURE LightBar( x, y, Len, Col: Integer);
VAR
  p: ^Byte;
BEGIN
  HideMouse;
  p:= Ptr( $B800, ((Hi(WindMin)+y-1)*80+Lo(WindMin)+x-1)*2+1);
  WHILE Len>0 DO BEGIN
    p^:= Col;
    Inc( p, 2);
    Dec( Len);
  END;
  ShowMouse;
END;

(***************************************************************************)

FUNCTION GetMenu( VAR Choice: Integer; Len, Items: Integer): Boolean;
VAR wx, wy: Integer;
    mb, mx, my: Word;
    OK, Cancel, WasInWindow: Boolean;
    c: Char;
BEGIN
  wx:= WhereX; wy:= WhereY;
  OK:= False; Cancel:= False;
  LightBar( wx, wy+Choice, Len, col[cMenuBar]);
  REPEAT
    REPEAT
      Update;
      GetMouseDown( mb, mx, my);
    UNTIL (mb>0) OR KeyPressed;
    IF mb>0 THEN BEGIN
      WasInWindow:= InWindow( mx, my);
      IF not WasInWindow THEN LightBar( wx, wy+Choice, Len, col[cMenu]);
      REPEAT
        Update;
        IF InWindow( MouseX, MouseY) THEN BEGIN
          IF not WasInWindow THEN BEGIN
            LightBar( wx, wy+Choice, Len, col[cMenuBar]);
            WasInWindow:= True
          END;
          MakeLocal( MouseX, MouseY);
          IF (MouseY>=wy) AND (MouseY<wy+Items) AND
             (MouseX>=wx) AND (MouseX<wx+Len) AND (Choice<>MouseY-wy) THEN BEGIN
            LightBar( wx, wy+Choice, Len, col[cMenu]);
            Choice:= MouseY-wy;
            LightBar( wx, wy+Choice, Len, col[cMenuBar]);
	  END;
        END
        ELSE
	  IF WasInWindow THEN BEGIN
            LightBar( wx, wy+Choice, Len, col[cMenu]);
            WasInWindow:= False
          END;
        GetMouseUp( mb, mx, my);
      UNTIL (mb>0);
      OK:= WasInWindow AND (MouseY>=wy) AND (MouseY<wy+Items) AND
	     (MouseX>=wx) AND (MouseX<wx+Len);
      Cancel:= not InWindow( mx, my);
    END;
    IF KeyPressed THEN BEGIN
      c:= ReadKey;
      LightBar( wx, wy+Choice, Len, col[cMenu]);
      IF c=#0 THEN CASE ReadKey OF
        kUp: IF Choice>0 THEN Dec( Choice){ ELSE Choice:= Items-1};
        kDown: IF Choice<Items-1 THEN Inc( Choice) {ELSE Choice:= 0};
        kHome: Choice:= 0;
        kEnd: Choice:= Items-1;
      END
      ELSE CASE c OF
        kESC: Cancel:= True;
        kEnter: OK:= True;
      END;
      LightBar( wx, wy+Choice, Len, col[cMenuBar]);
    END;
  UNTIL OK OR Cancel;
  GetMenu:= Ok;
END;

(***************************************************************************)

PROCEDURE ChangeBackground;
VAR BkCol: Byte;
    c: Byte;
BEGIN
  BkCol:= (col[cIdent] + $10) AND $70;
  FOR c:= cString TO cSymbol DO
    col[c]:= col[c] AND NOT $F0 OR BkCol;
  ShowFile;
END;

(***************************************************************************)

PROCEDURE ChangeDefColors;
BEGIN
  IF col[cIdent]=col1[cIdent]
    THEN col:= col2
    ELSE col:= col1;
  InitScreen;
END;

(***************************************************************************)

PROCEDURE ChangeColors;
VAR i: Integer;
    Done: Boolean;
    ColChoice, NewCol: Integer;
BEGIN
  Done:= False;
  REPEAT
    TextAttr:= col[ cMenu];
    CenterWin( 35, 4+SyntaxMenuItems);
    WriteCenter( ' Farben ndern ');
    FOR i:= 0 TO SyntaxMenuItems-1 DO
      WriteCenter( SyntaxMenu[i].Name);
    GotoXY( 7, 3);
    IF GetMenu( SyntaxChoice, 24, SyntaxMenuItems) THEN BEGIN
      NewCol:= SyntaxMenu[ SyntaxChoice]. Value;
      TextAttr:= col[ cMenu];
      RestoreWin;
      CenterWin( 30, 4+ColorMenuItems);
      WriteCenter( ' '+SyntaxMenu[ SyntaxChoice]. Name+' ');
      FOR i:= 0 TO ColorMenuItems-1 DO
        WriteCenter( ColorMenu[i].Name);
      GotoXY( 7, 3);
      ColChoice:= 0;
      WHILE (ColorMenu[ColChoice].Value<>(col[NewCol] and $0f))
            and (ColChoice<ColorMenuItems-1) DO
        Inc( ColChoice);
      IF GetMenu( ColChoice, 19, ColorMenuItems) THEN
        col[NewCol]:= col[cIdent] AND $70 OR ColorMenu[ColChoice].Value;
    END
    ELSE Done:= True;
    RestoreWin;
    ShowFile;
  UNTIL Done;
END;

(***************************************************************************)

FUNCTION GetConfigName: String;
BEGIN
  GetConfigName:= UpStr(Copy( ParamStr(0), 1, Length( ParamStr(0))-3)+'CFG');
END;

(***************************************************************************)

PROCEDURE SaveConfig;
VAR Name: String;
    f: File;
    l: Integer;
    OK, Cancel: Boolean;
    c: Char;
    mb, mx, my: Word;
    oMode: Word;
BEGIN
  Name:= GetConfigName;
  l:= Length( Name);
  IF l<30 THEN l:= 30; l:= l+14;
  TextAttr:= col[ cWin];
  CenterWin( l, 8);
  WriteCenter( ' Konfiguration sichern ');
  WriteLn;
  WriteCenter( Name);
  WriteLn;
  TextAttr:= col[ cInput];
  l:= l div 2-3;
  GotoXY( l, WhereY);
  Write( '   OK   ');
  OK:= False; Cancel:= False;
  REPEAT
    Update;
    GetMouseUp( mb, mx, my);
    IF mb>0 THEN Cancel:= not InWindow( mx, my)
    ELSE IF GetSwitches( l, WhereY, 8, 1)=1 THEN OK:= True
    ELSE IF KeyPressed THEN BEGIN
      c:= ReadKey;
      CASE c OF
        #0: c:= ReadKey;
        kESC: Cancel:= True;
        kEnter, ' ': OK:= True;
      END;
    END;
  UNTIL OK OR Cancel;
  IF OK THEN BEGIN
    RestoreWin;
    Assign( f, Name);
    oMode:= FileMode;
    FileMode:= 1;                      (* nur Schreiben *)
    Rewrite( f, 1);
    FileMode:= oMode;
    IF IOResult<>0 THEN ShowError( 'Kann Datei nicht schreiben:', Name)
    ELSE BEGIN
      BlockWrite( f, Capitals, SizeOf( Capitals));
      BlockWrite( f, col, SizeOf( col));
      BlockWrite( f, CharSet, SizeOf( CharSet));
      BlockWrite( f, TabWidth, SizeOf( TabWidth));
      BlockWrite( f, XChar, SizeOf( XChar));
      Close( f);
    END;
  END;
  RestoreWin;
  ShowFile;
END;

(***************************************************************************)

PROCEDURE LoadConfig;
VAR f: File;
    oMode: Word;
    i: Integer;
BEGIN
  Assign( f, GetConfigName);
  oMode:= FileMode;
  FileMode:= 0;                      (* nur Lesen *)
  {$IFDEF Test} {$I-} {$ENDIF}
  Reset( f, 1);
  {$IFDEF Test} {$I+} {$ENDIF}
  FileMode:= oMode;
  IF IOResult=0 THEN BEGIN
    BlockRead( f, Capitals, SizeOf( Capitals));
    BlockRead( f, col, SizeOf( col));
    BlockRead( f, CharSet, SizeOf( CharSet));
    BlockRead( f, TabWidth, SizeOf( TabWidth));
    BlockRead( f, XChar, SizeOf( XChar));
    Close( f);
    IF not (Capitals in [0..3]) THEN Capitals:= 0;
    IF not (CharSet in [0..1]) THEN CharSet:= 0;
    IF not (XChar in [0..1]) THEN XChar:= 0;
    IF not (TabWidth in [1..TabMax]) THEN TabWidth:= 8;
    InOutRes:= 0;
  END ELSE
    IF Mem[$B800:161]= 16 * Blue + White THEN
       col:= col2;
END;

(***************************************************************************)

procedure GetParameter;
var p: PChar;
    c: integer;
begin
  if Copy(paramstr(1), 1, 4)='/MEM' then begin
    Val(Copy(paramstr(1), 5, 255), LongInt(p), c);
    Inc( p);
    FileName:= StrPas(p);
    p:= StrEnd(p)+1; (* file *)
    p:= StrEnd(p)+1; (* Socha *)
    p:= StrEnd(p)+1; (* #31#1#1 *)
    SkipMouse:= StrComp( p, #1#1#1#0)=0;
  end
  else begin
    FileName:= ParamStr(1);
    SkipMouse:= (ParamCount>3) AND (ParamStr(3)=#255) AND (ParamStr(2)='Socha');
  end;
end;

(***************************************************************************)

VAR c: Char;
    Ende: Boolean;
BEGIN
  IF ParamCount=0 THEN BEGIN
    WriteLn( 'Pascal-Betrachter, V. '+Version+
             ', Copyright (C) 1994-95, Bert Schnwlder');
    WriteLn;
    WriteLn( 'Syntax: pasview <Dateiname>');
    Halt(1);
  END;
  GetCountryInfo;
  GetParameter;
  IF Length( FileName)<SizeOf(TextName)
    THEN TextName:= FileName
    ELSE TextName:= Copy( FileName, 1, 2)+'...'
                    +Copy( FileName,
                           Length(FileName)-SizeOf(TextName)+7, 255);
  col:= col1;
  LoadConfig;
  CheckVGA;
  oWindMin:= WindMin; oWindMax:= WindMax;
  IF SkipMouse
    THEN ButtonCount:= 2
    ELSE InitMouse;
  New( f, Init( 256, 256));
  ReadFile;
  CursOff;
  ShowMouse;
  InitScreen;
  LastTime:= Timer; TimeCount:= 0;
  x:= 0; y:= 0; xo:=x; yo:= y; Ende:= False;
  REPEAT
    Update;
    IF (xo<>x) OR (yo<>y) THEN BEGIN
      IF DoSearch THEN xo:= MaxInt;
      DoSearch:= False;
      ShowFile;
      ShowStatus;
    END;
    IF KeyPressed THEN BEGIN
      TimeCount:=0;
      c:= ReadKey;
      IF c=#0 THEN
	CASE ReadKey OF
	  kLeft  : Dec( x, 2);
	  kRight : Inc( x, 2);
	  kCtrlLeft: Dec( x, 2*8);
	  kCtrlRight: Inc( x, 2*8);
	  kUp    : Dec( y);
	  kDown  : Inc( y);
	  kPgUp  : Dec( y, Hi( WindMax)-2);
	  kPgDown: Inc( y, Hi( WindMax)-2);
	  kHome, kCtrlPgUp: BEGIN x:=0; y:= 0 END;
	  kEnd, kCtrlPgDn: BEGIN x:=0; y:= MaxCollectionSize END;
	  kF1: ShowHelp;
	  kF2: SaveConfig;
	  kF3: NextXChar;
	  kF4: NextCapitals;
	  kF5: ChangeColors;
	  kF6: NextTabWidth( TabWidth+1);
	  kShiftF6: NextTabWidth( TabWidth-1);
	  kShiftF5: ChangeBackGround;
	  kAltF5: ChangeDefColors;
	  kF7: Search;
	  kShiftF7: SearchAgain;
	  kF8: NextCharSet;
	  kF10: Ende:= TRUE;
	END
      ELSE
	CASE c OF
	  ^D: Inc( x, 2);
	  ^S: Dec( x, 2);
	  ^X: Inc( y);
	  ^E: Dec( y);
	  ^R: Dec( y, Hi( WindMax)-2);
	  ^C: Inc( y, Hi( WindMax)-2);
	  kESC: Ende:= TRUE;
	  '1'..'8': NextTabWidth( Byte(c)-Byte('0'));
	END;
    END;
    CASE GetFunc OF
      1: ShowHelp;
      2: SaveConfig;
      3: NextXChar;
      4: NextCapitals;
      5: ChangeColors;
      6: NextTabWidth( TabWidth+1);
      7: Search;
      8: NextCharSet;
      10: Ende:= True;
      0: IF MouseBut>0 THEN
	IF MouseY<MouseYMin THEN Dec( y)
	ELSE IF MouseY>MouseYMax THEN Inc( y)
	ELSE IF MouseX<MouseXMin THEN Dec( x, 2)
	ELSE IF MouseX>MouseXMax THEN Inc( x, 2);
    END;
  UNTIL Ende;
  HideMouse;
  Dispose( f, Done);
  TextAttr:= col[ cNorm]; ClrScr;
END.
