{$X+}
{$M 2048,0,0}
{$IFDEF Debug}
  {$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q+,R+,S+,T-,V-,X+,Y+}
{$ELSE}
  {$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-}
{$ENDIF}

(* Stand: 5.1.96 *)

program BBBView;

type
  TColor = ( cWin, cOption);
  TColors = array[ TColor] of Byte;

const
  Version = '1.0';
  Colors: TColors =
    ( $9f, $f0);                                           (* Default *)
  DarkColors: TColors =
    ( $1f, $70);                                           (* non VGA *)
  MonoColors: TColors =
    ( $70, $07);                                              (* Mono *)

  Config: PChar = Ptr($8800, 0000);                   (* Novell DOS 7 *)
  ShowAll: Boolean = False;

var
  Color: Byte;
  Current: PChar;
  CurrentX: Integer;

(* Low level ***************************************************************)

function IsVGA: Boolean; assembler;
asm
        mov     ax,1A00h
        int     10h
        cmp     al,1Ah
        mov     al,True
        je      @end
        mov     al,False
@end:
end;

procedure SetBlink( Enable: Boolean); assembler;
asm
        mov     ax,1003h
        mov     bl,enable
        int     10h
end;

procedure MoveCursor( x, y: Byte); assembler;
asm
  mov ah,2
  mov bh,0
  mov dh,y
  mov dl,x
  int $10
end;

function GetKey: Word; assembler;
asm
  mov ah,0
  int 16h
end;

function KeyPressed: Boolean; assembler;
asm
  mov ah,1
  int 16h
  mov ax,False
  jz @1
  mov ax,True
@1:
end;

(* Screen ******************************************************************)

const
  MonoBase = $3B4;

type
  TScreenElem = record
    c: Char;
    a: Byte;
  end;
  PScreen = ^TScreen;
  TScreen = array[0..MaxInt-1] of TScreenElem;

var
  Screen, SaveScreen: PScreen;
  SaveCursor: Word;
  ScreenSize: Word absolute $40:$4C;
  ScreenW   : Word absolute $40:$4A;
  ScreenBase: Word absolute $40:$63;
  ScreenHVGA: Byte absolute $40:$84;
  ScreenH   : Word;

function GetCursor: Word; assembler;
asm
  mov ah,3
  mov bh,0
  int 10h
  mov ax,dx
end;

procedure SetCursor( w: Word); assembler;
asm
  mov dx,w
  mov ah,2
  mov bh,0
  int 10h
end;

procedure InitScreen;
begin
  if ScreenBase=MonoBase then begin
    Screen:= Ptr( $B000, 0000);
    Colors:= MonoColors;
  end else begin
    Screen:= Ptr( $B800, 0000);
    if not isVGA then Colors:= DarkColors;
  end;
  if IsVGA
    then ScreenH:= ScreenHVGA
    else ScreenH:= ScreenSize div ScreenW div 2;
  SaveScreen:= Pointer(PChar(Screen)+ScreenSize);
  Move( Screen^, SaveScreen^, ScreenSize);
  SaveCursor:= GetCursor;
  if IsVga then SetBlink(False);
end;

procedure DoneScreen;
begin
  Move( SaveScreen^, Screen^, ScreenSize);
  SetCursor( SaveCursor);
  if IsVga then SetBlink(True);
end;

procedure BiosPrint( c: char); assembler;
asm
     mov ah,0eh
     mov al,c
     cmp al,9
     jne @1
     mov al,' '
@1:  int 10h
end;

procedure Print( const s: String);
var i: Integer;
begin
  for i:= 1 to length(s) do BiosPrint(s[i]);
end;

(* Output ******************************************************************)

var
  PosX, PosY: Word;                                    (* current Position *)

procedure PutChar( ch: Char);
begin
  with Screen^[PosY*ScreenW+PosX] do begin
    c:= ch;
    a:= Color;
  end;
  Inc( PosX);
end;

procedure PutString( const s: String);
var i: Integer;
begin
  for i:= 1 to length(s) do PutChar( s[i]);
end;

procedure CenterString( const s: String);
begin
  PosX:= (ScreenW-Length(s)) div 2+1;
  PutString( s);
  Inc( PosY);
end;

(* Window ******************************************************************)

type
  TLineChars = array[0..2] of Char;

var
  WinX, WinY, WinW, WinH, WinB: Word;

procedure Line( Chars: TLineChars);
var w: Word;
begin
  PosX:= WinX-2; w:= WinW+2;
  PutChar( ' ');
  PutChar( Chars[0]);
  while w>2 do begin
    PutChar( Chars[1]);
    Dec( w);
  end;
  PutChar( Chars[2]);
  PutChar( ' ');
  PosX:= WinX; Inc( PosY);
end;

procedure CenterWin( w, h: Word);
begin
  WinW:= w; WinH:= h;
  WinX:= (ScreenW-w) div 2+1;
  WinY:= (ScreenH-h) div 2+1;
  PosY:= WinY;
  Line( 'ͻ');
  while h>2 do begin
    Line( ' ');
    Dec( h);
  end;
  Line( 'ͼ');
end;

(***************************************************************************)

procedure PaintFile;
var p: PChar;
    y, MaxX: Integer;
    eol: Boolean;
    left: Integer;

  procedure OutChar( c: Char);
  begin
    if left=0 then PutChar(c) else Dec(left);
  end;
begin
  Color:= Colors[cOption];
  p:= Current;
  MaxX:= WinX+WinW-1;
  for PosY:= WinY+1 to WinY+WinH-2 do begin
    PosX:= WinX+1;
    eol:= False;
    left:= CurrentX;
    while PosX<MaxX do begin
      if not eol and (p^ in [#10,#13,#$1a]) then begin
        if (p^=#$1A) or ShowAll then OutChar(p^);
        Inc(p);
        if p^ in [#10, #13] then begin
          if ShowAll then OutChar(p^);
          Inc(p);
        end;
        eol:= true;
      end;
      if not eol then begin
        if p^<>#9 then OutChar(p^)
        else repeat OutChar(' ') until ((PosX-WinX-1+CurrentX-left) and 7=0) or (PosX>=MaxX);
        Inc(p);
      end else OutChar(' ');
    end;
    while not eol do
      if (p^ in [#10,#13,#$1a]) then begin
        Inc(p);
        if p^ in [#10, #13] then Inc(p);
        eol:= true;
      end else Inc(p);
  end;
end;

procedure PaintWin;
var eWidth, wWidth, i: Integer;
begin
  Color:= Colors[cWin];
  eWidth:= 0;
  CenterWin( ScreenW-8, ScreenH-3);
  PosY:= WinY;
  CenterString(' BBB View v'+Version+' ');
  PosY:= WinY+WinH-1;
  CenterString(' (c) 1995 Bert Schnwlder ');
  PaintFile;
end;

(***************************************************************************)

procedure Up;
begin
  if Current>Config+$8000 then exit;
  repeat Inc(Current) until Current^ in [#10,#13,#$1a];
  Inc(Current);
  if Current^ in [#10, #13] then Inc(Current);
end;

procedure Down;
var p: PChar;
begin
  p:= Current;
  Dec(Current);
  if Current^ in [#10, #13] then Dec(Current);
  repeat Dec(Current) until Current^ in [#10,#13,#$1a];
  Inc(Current);
  if p<Current then Current:= Config;
end;

function MainLoop: Boolean;
var c: Word;
    i: Integer;
begin
  repeat
    c:= GetKey;
    case char(c) of
      #0: case char(hi(c)) of
        #80: Up;
        #72: Down;
        #81: for i:=1 to WinH-2 do Up;
        #73: for i:=1 to WinH-2 do Down;
        #77: if CurrentX<$FFFF then Inc(CurrentX);
        #75: if CurrentX>0 then Dec(CurrentX);
        #71: begin Current:= Config; CurrentX:= 0; end;
        #61: ShowAll:= not ShowAll;
      end;
    end;
    PaintFile;
  until char(c)in [#27, #13];
end;

(***************************************************************************)
{$IFDEF Debug}
var
  buf: Array[0..10000] of byte;

procedure LoadConfig;
var f: file;
    read: Word;
begin
  assign(f, 'config.bbl');
  reset(f,1);
  blockread( f, buf, sizeof(buf), read);
  close(f);
  Config:= @buf;
  buf[read]:= $1A;
end;
{$ENDIF}

(* Main ********************************************************************)

var code: Word;
begin
  Print( #13#10'BBB View v'+Version+' (c) 1995 Bert Schnwlder'#13#10#10);
{$IFDEF Debug}
  LoadConfig;
{$ENDIF}
  If (ParamCount>0) then val(ParamStr(1), longint(Config), code);
  InitScreen;
  Current:= Config;
  CurrentX:= 0;
  PaintWin;
  MainLoop;
  DoneScreen;
end.
