{$X+}
{$M 4096,0,0}
{$IFDEF Debug}
  {$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q+,R+,S+,T-,V-,X+,Y+}
{$ELSE}
  {$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-}
{$ENDIF}

(* Stand: 5.1.96 *)

program BBBLight;

{$IFDEF Debug}
Uses Dos;
{$ENDIF}

type
  TColor = ( cWin, cOption, cHot, cLight);
  String8 = String[8];
  String16 = String[16];
  String31 = String[36];
  String128 = String[128];

type TColors = array[ TColor] of Byte;

const
  Version = '1.0';
  Colors: TColors =
    ( $9f, $f0, $0c, $f9);                                 (* Default *)
  DarkColors: TColors =
    ( $1f, $70, $0e, $7f);                                 (* non VGA *)
  MonoColors: TColors =
    ( $70, $07, $01, $07);                                    (* Mono *)

  Config: PChar = Ptr($8800, 0000);                   (* Novell DOS 7 *)
  TimeOut: Integer = 0;

const
  MaxVars = 48;                             (* up to max. screen rows *)
  MaxElems = MaxVars;

var
  ScanLine: PChar;                                    (* Current Line *)
  LineNr: Word;                                       (* Current Line *)
  ScanOk: Boolean;                                    (* option found *)
  ErrorLine: PChar;
  Errors: Word;
  BBBLine: PChar;                                      (* call to bbb *)
  EndOfFile: PChar;                                    (* call to bbb *)

type
  TElemTyp = (elCheckBox, elRadioButton);
  TElemNr = -1..MaxElems;
var
  Elems: TElemNr;

(* Low level ***************************************************************)

function IsVGA: Boolean; assembler;
asm
        mov     ax,1A00h
        int     10h
        cmp     al,1Ah
        mov     al,True
        je      @end
        mov     al,False
@end:
end;

procedure SetBlink( Enable: Boolean); assembler;
asm
        mov     ax,1003h
        mov     bl,enable
        int     10h
end;

procedure Set8x8; assembler;
asm
        mov     ax,1112h
        mov     bl,0
        int     10h
end;

procedure Set8x16; assembler;
asm
        mov     ax,1114h
        mov     bl,0
        int     10h
end;

procedure MoveCursor( x, y: Byte); assembler;
asm
  mov ah,2
  mov bh,0
  mov dh,y
  mov dl,x
  int $10
end;

function GetKey: Word; assembler;
asm
  mov ah,0
  int 16h
end;

function KeyPressed: Boolean; assembler;
asm
  mov ah,1
  int 16h
  mov ax,False
  jz @1
  mov ax,True
@1:
end;

function max( a, b: Byte): Byte; assembler;
asm
  mov al,a
  cmp al,b
  jnb @1
  mov al,b
@1:
end;

function min( a, b: Word): Word; assembler;
asm
  mov ax,a
  cmp ax,b
  jb @1
  mov ax,b
@1:
end;

(* Screen ******************************************************************)

const
  MonoBase = $3B4;

type
  TScreenElem = record
    c: Char;
    a: Byte;
  end;
  PScreen = ^TScreen;
  TScreen = array[0..MaxInt-1] of TScreenElem;

var
  Screen, SaveScreen: PScreen;
  SaveCursor: Word;
  ScreenSize: Word absolute $40:$4C;
  ScreenW   : Word absolute $40:$4A;
  ScreenBase: Word absolute $40:$63;
  ScreenHVGA: Byte absolute $40:$84;
  ScreenH   : Word;

function GetCursor: Word; assembler;
asm
  mov ah,3
  mov bh,0
  int 10h
  mov ax,dx
end;

procedure SetCursor( w: Word); assembler;
asm
  mov dx,w
  mov ah,2
  mov bh,0
  int 10h
end;

procedure InitScreen;
begin
  if isVGA and (Elems>22) then Set8x8;
  if ScreenBase=MonoBase then begin
    Screen:= Ptr( $B000, 0000);
    Colors:= MonoColors;
  end else begin
    Screen:= Ptr( $B800, 0000);
    if not isVGA then Colors:= DarkColors;
  end;
  if IsVGA
    then ScreenH:= ScreenHVGA
    else ScreenH:= ScreenSize div ScreenW div 2;
  SaveScreen:= Pointer(PChar(Screen)+ScreenSize);
  Move( Screen^, SaveScreen^, ScreenSize);
  SaveCursor:= GetCursor;
  if isVGA then SetBlink( False);
end;

procedure DoneScreen;
begin
  Move( SaveScreen^, Screen^, ScreenSize);
  if isVGA and (Elems>22) then Set8x16;
  SetCursor( SaveCursor);
  if IsVGA then SetBlink( True);
end;

procedure BiosPrint( c: char); assembler;
asm
     mov ah,0eh
     mov al,c
     cmp al,9
     jne @1
     mov al,' '
@1:  int 10h
end;

procedure Print( const s: String);
var i: Integer;
begin
  for i:= 1 to length(s) do BiosPrint(s[i]);
end;

procedure ClrLine;
var i: Integer;
begin
  BiosPrint( #13);
  for i:=2 to ScreenW do BiosPrint( ' ');
  BiosPrint( #13);
end;

procedure Wait;
begin
  Print( 'Press a key to continue');
  GetKey;
  ClrLine;
  BiosPrint( #10);
end;

procedure Error( const err: string);
var p: PChar;
    i: Integer;
    nr: string16;
begin
  if ScanLine<>ErrorLine then begin
    ErrorLine:= ScanLine;
    str( LineNr, nr);
    Print( 'Error in line ');
    Print( nr);
    Print( ' ');
    p:= ErrorLine; i:= 40;
    while not (p^ in [#$0a,#$0d,#$1a]) and (i>0) do begin
      BiosPrint( p^);
      Inc(p);
      Dec(i);
    end;
    Print( ''#13#10);
  end;
  Print( '  - ');
  Print( err);
  Print( #13#10);
  Inc( Errors);
  if Errors>10 then begin
    Wait;
    Errors:= 1;
  end;
end;

(* Output ******************************************************************)

var
  PosX, PosY: Word;                                    (* current Position *)
  Color: Byte;                                            (* current Color *)

procedure SetColor( c: TColor);
begin
  if c=cHot
    then Color:= (Color and $F0) or (Colors[cHot] and $0f)
    else Color:= Colors[c];
end;

procedure PutChar( ch: Char);
begin
  with Screen^[PosY*ScreenW+PosX] do begin
    c:= ch;
    a:= Color;
  end;
  Inc( PosX);
end;

procedure PutString( const s: String128; Hot: Byte);
var i: Integer;
    c: Byte;
begin
  if hot>0 then begin
    for i:= 1 to Hot-1 do PutChar( s[i]);
    c:= Color;
    SetColor( cHot);
    PutChar( s[Hot]);
    Color:= c;
  end;
  for i:= Hot+1 to Length( s) do PutChar( s[i]);
end;

procedure CenterString( const s: String128; Hot: Byte);
begin
  PosX:= (ScreenW-Length(s)) div 2+1;
  PutString( s, Hot);
  Inc( PosY);
end;

(* Window ******************************************************************)

type
  TLineChars = array[0..2] of Char;

var
  WinX, WinY, WinW, WinH, WinB: Word;

procedure Line( Chars: TLineChars);
var w: Word;
begin
  SetColor( cWin);
  PosX:= WinX-2; w:= WinW+2;
  PutChar( ' ');
  PutChar( Chars[0]);
  while w>2 do begin
    PutChar( Chars[1]);
    Dec( w);
  end;
  PutChar( Chars[2]);
  PutChar( ' ');
  PosX:= WinX; Inc( PosY);
end;

procedure CenterWin( w, h: Word);
begin
  WinW:= w; WinH:= h;
  WinX:= (ScreenW-w) div 2+1;
  WinY:= (ScreenH-h) div 2+1;
  PosY:= WinY;
  Line( 'ͻ');
  while h>2 do begin
    Line( ' ');
    Dec( h);
  end;
  Line( 'ͼ');
end;

(* Variables ***************************************************************)

type
  TVar = record
    Typ: TElemTyp;
    Value: Byte;
    Len: Byte;                         (* length of ?"..." *)
                                       (* first label for SWITCH *)
    Def: PChar;                        (* Definition *)
  end;

type
  TVarNr = 0..MaxVars;
  TVarArray = array[0..MaxVars-1] of TVar;

var
  VarArray: TVarArray;
  Vars: TVarNr;

procedure InitVar( aTyp: TElemTyp; aLen: Byte);
begin
  with VarArray[Vars] do begin
    Def:= ScanLine;
    Typ:= aTyp;
    if aTyp=elRadiobutton then Value:= 1 else Value:= 0;
    Len:= aLen;
  end;
end;

(* Dialog Elements *********************************************************)

type
  TElem = object
    Typ: TElemTyp;
    Title: String31;
    HotPos: Byte;
    HotKey: Char;
    VarNr: TVarNr;                                (* for options only*)
    Value: Byte;                             (* for Radiobuttons only*)
    procedure SetTitle( aTitle: String31);
    procedure Init( aTyp: TElemTyp; aVarNr: TVarNr; aValue: Byte);
    procedure Paint;
    procedure Press;
  end;

type
  TElemArray  = array[0..MaxElems-1] of TElem;

var
  ElemArray: TElemArray;
  Current: TElemNr;

procedure TElem.Init( aTyp: TElemTyp; aVarNr: TVarNr; aValue: Byte);
begin
  Typ:= aTyp;
  VarNr:= aVarNr;
  Value:= aValue;
end;

procedure TElem.SetTitle( aTitle: String31);
begin
  while (aTitle[1]=' ') and (length(aTitle)>0) do Delete(aTitle, 1, 1);
  if aTitle[1]='!' then begin
    Delete(aTitle, 1, 1);
    Press;
  end;
  while (aTitle[1]=' ') and (length(aTitle)>0) do Delete(aTitle, 1, 1);
  case Typ of
    elCheckBox: Title:= ' [ ] '+aTitle;
    elRadioButton: Title:= ' ( ) '+aTitle;
    else Title:= aTitle;
  end;
  HotPos:= Pos( '_', Title);
  if HotPos>0 then begin
    Delete( Title, HotPos, 1);
    HotKey:= UpCase(Title[ HotPos]);
  end else
    HotKey:= #0;
end;

procedure TElem.Paint;
begin
  if @self=@ElemArray[Current]
    then SetColor(cLight)
    else SetColor( cOption);
  case Typ of
    elRadioButton: if Value=VarArray[VarNr].Value
      then Title[3]:= ''
      else Title[3]:= ' ';
    elCheckBox: if VarArray[VarNr].Value=0
      then Title[3]:= ' '
      else Title[3]:= 'X';
  end;
  PutString( Title, HotPos);
end;

procedure TElem.Press;
begin
  case Typ of
    elRadioButton:
      VarArray[VarNr].Value:= Value;
    elCheckBox:
      VarArray[VarNr].Value:=1 - VarArray[VarNr].Value;
  end;
end;

(* Dialog ******************************************************************)

procedure PaintElems;
var i: Integer;
begin
  for i:= 0 to Elems-1 do begin
    PosX:= WinX+WinB;
    PosY:= WinY+1+i;
    ElemArray[i].Paint;
    while PosX<WinX+WinW-WinB do PutChar(' ');
  end;
end;

(***************************************************************************)

procedure Select( elem: TElemNr);
begin
  Current:= (elem+Elems) mod Elems;
  PaintElems;
  MoveCursor( WinX+WinB+2, WinY+1+Current);
end;

procedure PressCurrent;
begin
  ElemArray[Current].Press;
  PaintElems;
end;

function MainLoop: Boolean;
var c: Word;
    done: Boolean;
    i: Integer;
begin
  Select( 0);
  done:= False;
  repeat
    c:= GetKey;
    case char(c) of
      #13, #27: done:= True;
      ' ': PressCurrent;
      #0: case char(hi(c)) of
        #72, #75: Select(Current-1);
        #80, #77: Select(Current+1);
        #71: Select( 0);
        #79: Select( Elems);
      end;
    else
      for i:=0 to Elems-1 do with ElemArray[i] do
        if HotKey=UpCase(char(c)) then begin
          Press;
          Select( i);
          break;
        end;
    end;
  until done;
  MainLoop:= char(c)=#13;
end;

procedure TimerLoop;
var t: Byte;
    i: Integer;
    Timer: Byte absolute $40:$6c;
begin
  Select( 0);
  TimeOut:= (TimeOut*183) div 10;
  t:= Timer;
  SetColor( cWin);
  PosY:= WinY;
  repeat
    if t<>Timer then begin
      t:= Timer;
      Dec( TimeOut);
      if TimeOut=18 then exit;
      PosX:= WinX+WinW-2;
      i:= (TimeOut * 10) div 183;
      repeat
        PutChar(char(i mod 10+ord('0')));
        Dec(PosX,2);
        i:= i div 10;
      until i=0;
      PutChar(' ');
    end;
  until keyPressed;
  PosX:= WinX+WinW-4;
  PutString( '', 0);
end;

(***************************************************************************)

procedure PaintDialog;
var eWidth, wWidth, i: Integer;
begin
  eWidth:= 0;
  for i:= 0 to Elems-1 do eWidth:= max( eWidth, length(ElemArray[i].Title));
  wWidth:= max( ewidth+10, 31);
  WinB:= (wWidth-eWidth) div 2;
  CenterWin( wWidth, Elems+2);
  PosY:= WinY;
  CenterString(' BBB Light v'+Version+' ', 0);
  PosY:= WinY+WinH-1;
  CenterString(' (c) 1995 Bert Schnwlder ', 0);
  PaintElems;
end;

(***************************************************************************)

procedure AddCheckBox( var s: String128);
var p, r: Integer;
    t: String31;
    len: Byte absolute s;
begin
  p:= Pos('"', s);
  if p>0 then begin
    repeat inc(p) until (s[p]<>' ') or (p=len);
    r:= p;
    while (s[r]<>'"') and (r<len) do inc(r);
    if s[r]='"' then t:= Copy(s, p, r-p) else t:='';
  end else begin
    p:= Pos('?', s);
    r:= p;
    repeat inc( p) until (s[p]<>' ') or (p=len);
    t:= Copy(s, p, 255);
  end;
  for p:= 1 to r do s[p]:= ' ';
  if t='' then begin Error('irregular ?-command'); exit; end;
  if BBBLine=nil then exit;
  if (Vars<MaxVars) and (Elems<MaxElems) then begin
    InitVar( elCheckBox, r);
    with ElemArray[Elems] do begin
      Init( elCheckBox, Vars, 0);
      SetTitle( t);
    end;
    Inc( Elems);
    Inc( Vars);
  end;
  ScanOk:= True;
end;

procedure AddRadioButtons( const Titles: String128; first: Integer);
var button, i, p: Integer;
begin
  if BBBLine=nil then exit;
  if (Vars<MaxVars) and (Elems<MaxElems) then begin
    InitVar( elRadioButton, first-1);
    i:= 1;
    button:= 1;
    while (i<length(Titles)) and (button<10) and (Elems<MaxElems) do begin
      p:= i;
      while (Titles[i]<>',') and (i<=length(Titles)) do Inc(i);
      with ElemArray[Elems] do begin
        Init( elRadioButton, Vars, button);
        SetTitle( Copy( Titles, p, i-p));
      end;
      Inc( i);
      Inc( button);
      Inc( Elems);
    end;
    Inc( Vars);
  end;
  ScanOk:= True;
end;

procedure SetTimeOut( const s: String128);
var error: Word;
begin
  val( copy(s, 1, 3), TimeOut, error);
end;

(***************************************************************************)
{$IFDEF Debug}
var
  buf: Array[0..3000] of byte;

procedure LoadConfig;
var f: file;
    read: Word;
begin
  assign(f, 'config.bbl');
  reset(f,1);
  blockread( f, buf, sizeof(buf), read);
  close(f);
  Config:= @buf;
  buf[read]:= $1A;
end;

procedure view( p: PChar);
var opt: String31;
begin
  Str(LongInt(p), opt);
  SwapVectors;
  Exec( 'BBBVIEW.EXE', opt);
  SwapVectors;
end;
{$ENDIF}

(***************************************************************************)

procedure PrintChr( var dest: PChar; source: Char);
begin
  dest^:= source;
  Inc( dest);
end;

procedure PrintStr( var dest: PChar; const source: String128);
var i: Integer;
begin
  for i:= 1 to length( source) do
    PrintChr( dest, source[i]);
end;

procedure Execute;
var nr: TVarNr;
    dest: PChar;
    i: Integer;
begin
  for nr:= 0 to Vars-1 do with VarArray[nr] do begin
    dest:= Def;
    if Typ=elRadioButton then begin          (* SWITCH *)
      PrintStr( dest, 'GOSUB ');
      while dest<Def+Len do PrintChr(dest, ' ');
      i:=1;
      repeat
        if dest^=',' then Inc(i);
        if (i=Value) and (dest^<>',')
          then Inc(dest)
          else PrintChr( dest, ' ');
      until dest^ in [#10,#13,#$1A];
    end else begin               (* ? *)
      if Value=0 then
        PrintChr( dest, ';')
      else
        for i:= 1 to Len do PrintChr( dest, ' ');
    end;
  end;
end;

procedure FillToEof;
const bits: Array[0..7] of LongInt = (
        $33333200, $33001320, $33002310, $33333200,
        $33001320, $33002310, $33333100, $22222222);
      chars: Array[0..3] of Char= (' ', '', '', '');
var i, j, y: Integer;
    m: LongInt;
begin
  if BBBLine<=EndOfFile then begin
    PrintStr( BBBLine, #13#10'REM --- now fill to the end of file ---'#13#10);
    repeat
      PrintStr( BBBLine, #13#10);
      for y:= 0 to 7 do begin
        PrintStr( BBBLine, 'REM ');
        for i:= 0 to 5 do begin
          if i=3 then for j:= 1 to 7 do PrintChr( BBBLine, ' ');
          m:= bits[y];
          for j:= 0 to 7 do begin
            PrintChr( BBBLine, chars[(m shr 28) and 3]);
            m:= m shl 4;
          end;
        end;
        PrintStr( BBBLine, #13#10);
      end;
    until BBBLine>=EndOfFile;
  end;
  PrintChr(BBBLine, #$1a);
end;

(***************************************************************************)

var buffer: array[0..$8000] of char;
    bufsize: Word;

procedure CreateCopy;
var source, dest: PChar;
    c: Char;
begin
  while not (BBBLine^ in [#$0a, #$0d, #$1A]) do Inc(BBBLine);
  while BBBLine^ in [#$0a, #$0d] do Inc(BBBLine);
  source:= BBBLine;
  dest:= Buffer;
  bufSize:= 0;
  while (source^<>#$1a) and (BufSize<SizeOf(buffer)-1) do begin
    dest^:= source^;
    Inc( dest); Inc( source); Inc(BufSize);
  end;
  dest^:= #$1a;
end;

procedure AddLine( const key: String16; dev: char; const para: String128);
begin
  PrintStr( BBBLine, key);
  if para<>'' then begin
    PrintChr( BBBLine, dev);
    PrintStr( BBBLine, para);
  end;
  PrintStr( BBBLine, #13#10);
end;

(* Scanning - Pass 1 creates dialog, Pass 2 modifies CONFIG.SYS ************)

const
  StackSize = 64;

var
  Stack: array[0..StackSize] of PChar;
  Gosubs: array[0..StackSize] of PChar;
  SP: Word;
  SearchLabel: String8;                                  (* when Jumping *)
  SearchFrom: PChar;

function InitSearch( const para: String8): Boolean;
var i: Integer;
begin
  InitSearch:= False;
  if para='' then Error('no label')
  else begin
    SearchLabel:= para;
    for i:= 1 to length(SearchLabel) do
      SearchLabel[i]:= UpCase(para[i]);
    SearchFrom:= ScanLine;
    InitSearch:= True;
  end;
end;

procedure StartGosub( const para: String8; IP: PChar);
begin
  if InitSearch(para) then begin
    Stack[SP]:= IP;
    Gosubs[SP]:= ScanLine;
    Inc( SP);
  end;
end;

procedure EndGosub( var IP: PChar);
begin
  if SP>0 then begin
    Dec( SP);
    IP:= Stack[SP];
  end else Error( 'RETURN without GOSUB');
end;

procedure Scan( Pass: Integer);
var p, MaxP: PChar;
    i, j: Integer;
    s: String128;
    len: Byte absolute s;
    cond: Boolean;
    instr: String16;                               (* INSTALLHIGH is longest *)
    dev: Char;
begin
  if Pass=1 then p:= Config else p:= Buffer;
  MaxP:= p+$8000;
  LineNr:= 1;
  Errors:= 0;
  SearchLabel:= '';
  SP:= 0;
  while (p^<>#$1A) and (p<MaxP) do begin
    ScanLine:= p;                                          (* Current Line *)
    i:= 1;
    while not (p^ in [#$0a, #$0d, #$1A]) and (i<128) do begin
      if p^<>#9 then s[i]:= p^ else s[i]:= ' ';
      Inc(p); Inc(i);
    end;
    s[0]:= char(i-1);
    i:= 1;
    while (s[i]=' ') and (i<len) do Inc(i);             (* first non space *)
    if i<=len then begin
      if s[i]='?' then begin
        AddCheckBox(s);                        (* this replaces the ?"..." *)
        while (s[i]=' ') and (i<len) do Inc(i);
      end;
      if (i<len) and (s[i]<>';') then begin         (* get instruction and *)
        instr:= '';
        dev:= ' ';                                          (* devider and *)
        j:= i;
        while (j<=len) do begin
          if s[j] in [' ','='] then break else instr:=instr+UpCase(s[j]);
          Inc(j);
        end;
        while (s[j] in [' ','=']) and (j<=len) do begin
          if s[j]='=' then dev:= '=';
          inc(j);
        end;
        Delete( s, 1, j-1);
        while (len>0) and (s[len]=' ') do dec(len);           (* parameter *)
        if Pass=1 then begin
          if instr='SWITCH' then AddRadioButtons(s, i+7) else
          if instr='TIMEOUT' then SetTimeOut( s) else
          if Pos('INSTALL', instr)>0 then begin
            for i:= 1 to len do begin
              s[i]:= UpCase(s[i]);
              if s[i]=' ' then len:= i;     (* only get path *)
            end;
            if copy(s, len-11, 12)='BBBLIGHT.SYS' then
              if BBBLine=nil then BBBLine:= ScanLine
              else Print('Warning: you shouldn''t load BBBLight twice'#13#10);
          end;
        end else begin (* Pass=2 *)
          if SearchLabel='' then begin                    (* not searching *)
            if instr='EXIT' then p:= MaxP else
            if instr='GOTO' then InitSearch(s) else
            if instr='GOSUB' then StartGosub(s, p) else
            if instr='RETURN' then EndGosub(p) else
            if (instr<>'REM') and (instr<>'TIMEOUT') and (instr[1]<>':')
              then AddLine( instr, dev, s);
          end else begin                                      (* searching *)
            if (instr[1]=':') and (Copy(instr,2,8)=SearchLabel)
              then SearchLabel:= '';                              (* found *)
          end;
        end;
      end;
    end;
    while p^ in [#$0a, #$0d] do begin
      if p^=#$0a then Inc(LineNr);
      Inc(p);
    end;
  end;
  if Pass=1 then EndOfFile:= p;
  if SearchLabel<>'' then begin
    ScanLine:= SearchFrom;
    Error( 'label not found after this line');
  end;
  while SP>0 do begin
    Dec(SP);
    ScanLine:= Gosubs[SP];
    Error( 'GOSUB without RETURN');
  end;
end;

(***************************************************************************)

procedure Init;
begin
  Vars:= 0;
  Elems:= 0;
  ScanOk:= False;
  ScanLine:= Config;
  LineNr:= 1;
  Errors:= 0;
  ErrorLine:= NIL;
  BBBLine:= NIL;
end;

(* Main ********************************************************************)

var ok: Boolean;
begin
  Print( #13#10'BBB Light v'+Version+' (c) 1995 Bert Schnwlder'#13#10#10);
{$IFDEF Debug}
  LoadConfig;
{$ENDIF}
  Init;
  Scan(1);
  if BBBLine=nil then begin
    Print( 'Couldn''t find INSTALL=BBBLIGHT.SYS - aborting...'#13#10);
    Wait;
    exit;
  end;
  if Errors>0 then Wait;
  if ScanOk then begin
    InitScreen;
    PaintDialog;
    ok:= True;
    if TimeOut>0 then TimerLoop;
    if (TimeOut=0) OR KeyPressed then ok:= MainLoop;
    DoneScreen;
    if ok then Print( 'OK') else Print( 'Cancel');
    Print( ' was selected, BBB will ');
    if ok then Print('execute') else Print( 'not remove');
    Print( ' the SWITCH and ?-commands'#13#10);
    if ok then begin
      Execute;                                   (* replace switches and ? *)
      CreateCopy;
      PrintStr( BBBLine, 'REM --- this was created by BBBLight ---'#13#10);
      Scan(2);                                          (* build up linear *)
      PrintStr( BBBLine, 'REM --- the end ---'#13#10);
      FillToEOF;
      if Errors>0 then Wait;
{$IFDEF Debug}
      View( Config);
{$ENDIF}
    end;
  end else begin
    Print( 'Error: No Option found'#13#10);
    Wait;
  end;
end.
